/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.nls;

import de.intarsys.tools.component.SingletonClass;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ClassLoaderResourceLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.message.IMessageBundleFactory;
import de.intarsys.tools.message.MessageBundleFactory;
import de.intarsys.tools.message.OverrideMessageBundleFactory;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.util.Locale;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@SingletonClass
public class NlsEnvironment {
    private static final Logger Log = LoggerFactory.getLogger(NlsEnvironment.class);
    private static final String ARG_LANGUAGE = "language";
    private static final String ARG_LOGMODE = "logMode";
    private static final String ARG_OVERRIDELOCATOR = "overrideLocator";
    private static final String ARG_OVERRIDESUFFIX = "overrideSuffix";
    private static final String ARG_RAWMODE = "rawMode";
    private static final NlsEnvironment ACTIVE = new NlsEnvironment();

    public static NlsEnvironment get() {
        return ACTIVE;
    }

    private NlsEnvironment() {
    }

    public void configure(IArgs args) {
        OverrideMessageBundleFactory bundleFactory = this.getOrCreateExtendedMessageBundleFactory();
        String languageTag = ArgTools.getString(args, ARG_LANGUAGE, null);
        if (!StringTools.isEmpty(languageTag)) {
            this.setLocale(languageTag);
        }
        bundleFactory.setLogMode(ArgTools.getBoolStrict(args, ARG_LOGMODE, bundleFactory.isLogMode()));
        bundleFactory.setRawMode(ArgTools.getBoolStrict(args, ARG_RAWMODE, bundleFactory.isRawMode()));
        bundleFactory.setOverrideSuffix(ArgTools.getString(args, ARG_OVERRIDESUFFIX, bundleFactory.getOverrideSuffix()));
        ILocator overrideLocator = ArgTools.getLocator(args, ARG_OVERRIDELOCATOR, null, location -> new ClassLoaderResourceLocator(Thread.currentThread().getContextClassLoader(), location));
        if (overrideLocator != null) {
            try {
                bundleFactory.load(overrideLocator);
            }
            catch (IOException ex) {
                Log.warn("NLS override file '{}' failed to load", (Object)overrideLocator.getName(), (Object)ex);
            }
        }
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    protected OverrideMessageBundleFactory getOrCreateExtendedMessageBundleFactory() {
        IMessageBundleFactory bundleFactory = MessageBundleFactory.get();
        if (bundleFactory instanceof OverrideMessageBundleFactory) {
            return (OverrideMessageBundleFactory)bundleFactory;
        }
        OverrideMessageBundleFactory extendedFactory = new OverrideMessageBundleFactory();
        return extendedFactory;
    }

    protected void setLocale(Locale locale) {
        Locale.setDefault(locale);
        JComponent.setDefaultLocale(locale);
    }

    protected void setLocale(String languageTag) {
        Locale locale = Locale.forLanguageTag(languageTag);
        this.setLocale(locale);
    }
}

