/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.monitor.Counter;
import de.intarsys.tools.monitor.CounterMonitorTrace;
import de.intarsys.tools.monitor.Monitor;
import de.intarsys.tools.monitor.MonitorTrace;

public class CounterMonitor
extends Monitor {
    private Counter counter;

    public CounterMonitor() {
    }

    public CounterMonitor(String name) {
        super(name);
    }

    public CounterMonitor(String name, Counter counter) {
        super(name);
        this.counter = counter;
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        String counterName = ElementTools.getPathString(element, "countername", null);
        if (counterName == null) {
            throw new ConfigurationException("<countername> may not be null");
        }
        this.counter = Counter.get(counterName);
    }

    @Override
    protected CounterMonitorTrace createMonitorTrace() {
        return new CounterMonitorTrace(this);
    }

    @Override
    protected void doCalculation(MonitorTrace trace) {
        if (trace.getStart() < this.statistic.min) {
            this.statistic.min = trace.getStart();
        }
        if (trace.getStop() < this.statistic.min) {
            this.statistic.min = trace.getStop();
        }
        if (trace.getStart() > this.statistic.max) {
            this.statistic.max = trace.getStart();
        }
        if (trace.getStop() > this.statistic.max) {
            this.statistic.max = trace.getStop();
        }
        this.statistic.total = this.last - this.first;
        this.statistic.avg = (this.statistic.avg * this.statistic.count + trace.getStop()) / (this.statistic.count + 1L);
        ++this.statistic.count;
    }

    public Counter getCounter() {
        return this.counter;
    }
}

