/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.message;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.message.BasicMessageBundleFactory;
import de.intarsys.tools.message.CommonMessageBundle;
import de.intarsys.tools.message.CommonMessageBundleFactory;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.IMessageBundleFactory;
import de.intarsys.tools.message.OverrideMessageBundle;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverrideMessageBundleFactory
extends CommonMessageBundleFactory {
    private static final Logger Log = LoggerFactory.getLogger((String)"NLS");
    private final IMessageBundleFactory factory = new BasicMessageBundleFactory();
    private String overrideSuffix;

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        this.setOverrideSuffix(ElementTools.getString(element, "overrideSuffix", this.getOverrideSuffix()));
    }

    @Override
    protected CommonMessageBundle createMessageBundle(String name, ClassLoader classloader) {
        OverrideMessageBundle result = new OverrideMessageBundle(this, name);
        if (!StringTools.isEmpty(this.getOverrideSuffix())) {
            IMessageBundle overrideBundle = this.getFactory().getMessageBundle(name + this.getOverrideSuffix(), classloader);
            result.setOverrideBundle(overrideBundle);
        }
        return result;
    }

    public IMessageBundleFactory getFactory() {
        return this.factory;
    }

    public String getOverrideSuffix() {
        return this.overrideSuffix;
    }

    public void load(ILocator locator) throws IOException {
        Log.info("ExtendedMessageBundleFactory.load {}", (Object)locator.getPath());
        Properties properties = new Properties();
        InputStream is = null;
        try {
            is = locator.getInputStream();
            properties.load(is);
        }
        catch (Exception e) {
            StreamTools.close(is);
            throw e;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String extKey = (String)entry.getKey();
            this.register(extKey, (String)entry.getValue());
        }
    }

    public void register(String extKey, String value) {
        String[] ref = extKey.split("#");
        if (ref.length < 2) {
            Log.warn("ExtendedMessageBundleFactory.register '{}' malformed", (Object)extKey);
            return;
        }
        String bundle = ref[0];
        String key = ref[1];
        OverrideMessageBundle mb = (OverrideMessageBundle)this.getMessageBundle(bundle, this.getClass().getClassLoader());
        mb.register(key, value);
    }

    public void setOverrideSuffix(String overridePrefix) {
        this.overrideSuffix = overridePrefix;
    }

    public void unregister(String extKey) {
        String[] ref = extKey.split("#");
        if (ref.length < 2) {
            Log.warn("ExtendedMessageBundleFactory.register '{}' malformed", (Object)extKey);
        }
        String bundle = ref[0];
        String key = ref[1];
        OverrideMessageBundle mb = (OverrideMessageBundle)this.getMessageBundle(bundle, this.getClass().getClassLoader());
        mb.unregister(key);
    }
}

