/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.message;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.message.CommonMessageBundle;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.IMessageBundleFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonMessageBundleFactory
implements IMessageBundleFactory,
IElementConfigurable {
    private static final Logger Log = LoggerFactory.getLogger((String)"NLS");
    private final Map<String, CommonMessageBundle> bundles = new ConcurrentHashMap<String, CommonMessageBundle>();
    private boolean logMode;
    private boolean rawMode;

    protected CommonMessageBundleFactory() {
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        this.setLogMode(ElementTools.getBoolean(element, "logMode", this.isLogMode()));
        this.setRawMode(ElementTools.getBoolean(element, "rawMode", this.isRawMode()));
    }

    protected abstract CommonMessageBundle createMessageBundle(String var1, ClassLoader var2);

    @Override
    public IMessageBundle getMessageBundle(String name, ClassLoader classloader) {
        return this.bundles.computeIfAbsent(name, n -> {
            if (this.isLogMode()) {
                Log.info("MessageBundleFactory createMessageBundle {}", (Object)name);
            }
            return this.createMessageBundle(name, classloader);
        });
    }

    public boolean isLogMode() {
        return this.logMode;
    }

    public boolean isRawMode() {
        return this.rawMode;
    }

    public void setLogMode(boolean developMode) {
        this.logMode = developMode;
    }

    public void setRawMode(boolean rawMode) {
        this.rawMode = rawMode;
    }
}

