/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.macro;

import de.intarsys.tools.collection.ReverseListIterator;
import de.intarsys.tools.component.ComponentException;
import de.intarsys.tools.component.ComponentInternalException;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.FunctorExecutionException;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.macro.MacroControlFlow;
import de.intarsys.tools.macro.MacroFunctor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MacroBlock
extends MacroFunctor {
    private final List<IFunctor> blockExpressions = new ArrayList<IFunctor>();
    private final List<IFunctor> errorExpressions = new ArrayList<IFunctor>();
    private final List<IFunctor> finallyExpressions = new ArrayList<IFunctor>();

    public void addBlockExpression(IFunctor step) {
        this.addExpression(this.blockExpressions, step);
    }

    public void addBlockExpression(int index, IFunctor step) {
        this.addExpression(this.blockExpressions, index, step);
    }

    public void addErrorExpression(IFunctor step) {
        this.addExpression(this.errorExpressions, step);
    }

    public void addErrorExpression(int index, IFunctor step) {
        this.addExpression(this.errorExpressions, index, step);
    }

    protected void addExpression(List<IFunctor> expressions, IFunctor step) {
        if (step == null) {
            return;
        }
        this.associateChild(step);
        expressions.add(step);
    }

    protected void addExpression(List<IFunctor> expressions, int index, IFunctor step) {
        expressions.add(index, step);
    }

    public void addFinallyExpression(IFunctor step) {
        this.addExpression(this.finallyExpressions, step);
    }

    public void addFinallyExpression(int index, IFunctor step) {
        this.addExpression(this.finallyExpressions, index, step);
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        this.configureExpressions(element.element("block"), this.blockExpressions);
        this.configureExpressions(element.element("error"), this.errorExpressions);
        this.configureExpressions(element.element("finally"), this.finallyExpressions);
    }

    protected void configureExpressions(IElement stepsElement, List<IFunctor> steps) throws ConfigurationException {
        if (stepsElement == null) {
            return;
        }
        Iterator<IElement> itStep = stepsElement.elementIterator("step");
        while (itStep.hasNext()) {
            IElement stepElement = itStep.next();
            IFunctor step = this.createFunctor(stepElement);
            this.addExpression(steps, step);
        }
    }

    protected void disposeExpressions(List<IFunctor> steps) throws FunctorException {
        FunctorExecutionException se = null;
        ReverseListIterator<IFunctor> it = new ReverseListIterator<IFunctor>(steps);
        while (it.hasNext()) {
            IFunctor step = (IFunctor)it.next();
            try {
                this.disposeChild(step);
            }
            catch (Exception e) {
                if (se != null) continue;
                se = new FunctorExecutionException(e);
            }
        }
        if (se != null) {
            throw se;
        }
    }

    protected ComponentException disposeExpressions(List<IFunctor> expressions, ComponentException se) {
        block4: {
            try {
                this.disposeExpressions(expressions);
            }
            catch (ComponentException e) {
                if (se == null) {
                    se = e;
                }
            }
            catch (Exception e) {
                if (se != null) break block4;
                se = new ComponentInternalException(e);
            }
        }
        return se;
    }

    public List<IFunctor> getBlockExpressions() {
        return Collections.unmodifiableList(this.blockExpressions);
    }

    @Override
    protected String getDefaultLabel() {
        return "{ Block }";
    }

    public List<IFunctor> getErrorExpressions() {
        return Collections.unmodifiableList(this.errorExpressions);
    }

    public List<IFunctor> getFinallyExpressions() {
        return Collections.unmodifiableList(this.finallyExpressions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object perform(IFunctorCall call) throws FunctorException {
        try {
            Object object = this.performExpressions(this.blockExpressions, call);
            return object;
        }
        catch (MacroControlFlow e) {
            Object object = this.handleControlFlow(e);
            return object;
        }
        catch (Exception e) {
            if (this.errorExpressions.isEmpty()) {
                if (e instanceof FunctorException) {
                    throw e;
                }
                throw new FunctorExecutionException(e);
            }
            try {
                Object object = this.performExpressions(this.errorExpressions, call);
                return object;
            }
            catch (MacroControlFlow inner) {
                Object object = this.handleControlFlow(inner);
                try {
                    this.performExpressions(this.finallyExpressions, call);
                }
                catch (MacroControlFlow macroControlFlow) {
                    // empty catch block
                }
                return object;
            }
        }
        finally {
            try {
                this.performExpressions(this.finallyExpressions, call);
            }
            catch (MacroControlFlow macroControlFlow) {}
        }
    }

    protected Object performExpressions(List<IFunctor> steps, IFunctorCall call) throws FunctorException {
        Object result = null;
        for (IFunctor step : steps) {
            result = step.perform(call);
        }
        return result;
    }

    public void removeBlockExpression(IFunctor step) {
        this.blockExpressions.remove(step);
    }

    public void removeErrorExpression(IFunctor step) {
        this.errorExpressions.remove(step);
    }

    public void removeFinallyExpression(IFunctor step) {
        this.finallyExpressions.remove(step);
    }

    @Override
    public void serialize(IElement element) throws ElementSerializationException {
        IElement stepsElement;
        super.serialize(element);
        if (!this.blockExpressions.isEmpty()) {
            stepsElement = element.newElementMapped("block");
            this.serializeExpressions(stepsElement, this.blockExpressions);
        }
        if (!this.errorExpressions.isEmpty()) {
            stepsElement = element.newElementMapped("error");
            this.serializeExpressions(stepsElement, this.errorExpressions);
        }
        if (!this.finallyExpressions.isEmpty()) {
            stepsElement = element.newElementMapped("finally");
            this.serializeExpressions(stepsElement, this.finallyExpressions);
        }
    }

    protected void serializeExpressions(IElement element, List<IFunctor> steps) throws ElementSerializationException {
        for (IFunctor step : steps) {
            IElement stepElement = element.newElementMapped("step");
            this.serializeChildFunctor(step, stepElement);
        }
    }

    @Override
    public void setContext(Object context) throws ConfigurationException {
        super.setContext(context);
        this.setContextExpressions(this.blockExpressions, context);
        this.setContextExpressions(this.errorExpressions, context);
        this.setContextExpressions(this.finallyExpressions, context);
    }

    protected void setContextExpressions(List<IFunctor> steps, Object context) throws ConfigurationException {
        for (IFunctor step : steps) {
            this.setChildContext(step, context);
        }
    }
}

