/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.jmx;

import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;

public abstract class MBeanSupport {
    private NotificationBroadcasterSupport mbean;
    private ObjectName mbeanName;
    private int mbeanNotificationCounter;

    protected MBeanSupport() {
    }

    protected abstract NotificationBroadcasterSupport mbeanCreate();

    protected abstract void mbeanDeclareProperties(Hashtable<String, String> var1);

    protected String mbeanGetDomain() {
        return "de.intarsys";
    }

    public void mbeanPublish() throws JMException {
        this.mbean = this.mbeanCreate();
        String domain = this.mbeanGetDomain();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        this.mbeanDeclareProperties(properties);
        this.mbeanName = new ObjectName(domain, properties);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        server.registerMBean(this.mbean, this.mbeanName);
    }

    public void mbeanSendNotification(String type, String message) {
        if (this.mbean == null) {
            return;
        }
        Notification notification = new Notification(type, this.mbeanName, this.mbeanNotificationCounter++, System.currentTimeMillis(), message);
        this.mbean.sendNotification(notification);
    }

    public void mbeanUnpublish() throws JMException {
        if (this.mbeanName == null) {
            return;
        }
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        server.unregisterMBean(this.mbeanName);
        this.mbean = null;
        this.mbeanName = null;
    }
}

