/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ipc;

import de.intarsys.tools.component.IDisposable;
import de.intarsys.tools.ipc.IIPCScope;
import de.intarsys.tools.ipc.IPCHandle;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.UUID;

public class StandardIPCScope
implements IIPCScope,
IDisposable {
    private static int Counter;
    private final Map<String, IPCHandle> handlesByKey = new HashMap<String, IPCHandle>();
    private final Map<Object, IPCHandle> handlesByObject = new IdentityHashMap<Object, IPCHandle>();
    private final int id;
    private final Object lock = new Object();

    public StandardIPCScope() {
        this.id = Counter++;
    }

    protected IPCHandle createHandle(Object object) {
        IPCHandle handle = new IPCHandle(this, object, this.createId());
        return handle;
    }

    protected IPCHandle createHandle(String id) {
        IPCHandle handle = new IPCHandle(this, id);
        return handle;
    }

    protected String createId() {
        return "ipc://resolve/" + UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            this.handlesByKey.clear();
            this.handlesByObject.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPCHandle exportObject(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            return this.handlesByObject.computeIfAbsent(object, key -> {
                IPCHandle handle = this.createHandle(object);
                this.handlesByKey.put(handle.getId(), handle);
                return handle;
            });
        }
    }

    public int getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPCHandle importHandle(String id) {
        Object object = this.lock;
        synchronized (object) {
            return this.handlesByKey.computeIfAbsent(id, key -> this.createHandle(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolve(IPCHandle handle) {
        Object object = this.lock;
        synchronized (object) {
            this.handlesByObject.put(handle.getObject(), handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.handlesByKey.size();
        }
    }
}

