/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ipc;

import de.intarsys.tools.component.Singleton;
import de.intarsys.tools.ipc.IIPCScope;
import de.intarsys.tools.ipc.StandardIPCScope;

@Singleton
public class IPCScope {
    private static final ThreadLocal<IIPCScope> ACTIVE = new ThreadLocal();

    public static IIPCScope create() {
        return new StandardIPCScope();
    }

    public static IIPCScope get() {
        IIPCScope scope = ACTIVE.get();
        if (scope == null) {
            scope = IPCScope.create();
            IPCScope.set(scope);
        }
        return scope;
    }

    public static IIPCScope lookup() {
        return ACTIVE.get();
    }

    public static void set(IIPCScope scope) {
        if (scope == null) {
            ACTIVE.remove();
        } else {
            ACTIVE.set(scope);
        }
    }

    private IPCScope() {
    }
}

