/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.functor.Declaration;
import de.intarsys.tools.functor.IDeclarationElement;
import de.intarsys.tools.string.StringTools;
import java.util.regex.Pattern;

public abstract class DeclarationElement
extends Declaration
implements IDeclarationElement {
    private String modifierString;
    private String name;
    private String description;

    public static boolean validateName(String name) {
        if (StringTools.isEmpty(name)) {
            return false;
        }
        return Pattern.matches("[\\.]|[a-zA-Z0-9_]+", name);
    }

    protected DeclarationElement(Object declarationContext, String name, String modifiers) {
        this(declarationContext, name, modifiers, null);
    }

    protected DeclarationElement(Object declarationContext, String name, String modifiers, String description) {
        super(declarationContext);
        this.modifierString = modifiers;
        this.name = name;
        this.description = description;
    }

    public void addModifier(String modifier) {
        if (StringTools.isEmpty(this.modifierString)) {
            this.modifierString = modifier;
            return;
        }
        if (this.modifierString.indexOf(modifier) >= 0) {
            return;
        }
        this.modifierString = this.modifierString + ";" + modifier;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getModifiers() {
        if (StringTools.isEmpty(this.modifierString)) {
            return new String[0];
        }
        return this.modifierString.replaceAll("\\s", "").split("\\;");
    }

    @Override
    public String getModifierString() {
        return this.modifierString;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasModifier(String modifier) {
        if (this.modifierString == null) {
            return false;
        }
        return this.modifierString.indexOf(modifier) >= 0;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setModifierString(String modifierString) {
        this.modifierString = modifierString;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "declaration <'" + this.getName() + "'> [" + this.modifierString + "]";
    }
}

