/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.functor.IArgs;
import java.io.File;

public class FilenameResolver
implements IStringEvaluator {
    private final File file;
    private final String extensionPrefix;

    public FilenameResolver(File file) {
        this.file = file;
        this.extensionPrefix = null;
    }

    public FilenameResolver(File file, String extensionPrefix) {
        this.file = file;
        this.extensionPrefix = extensionPrefix;
    }

    @Override
    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        if ("path".equals(expression)) {
            return this.getPathName();
        }
        if ("basename".equals(expression)) {
            return this.getBaseName();
        }
        if ("extension".equals(expression)) {
            return this.getExtension();
        }
        if ("name".equals(expression)) {
            return this.getFileName();
        }
        if ("filename".equals(expression)) {
            return this.getFileName();
        }
        throw new EvaluationException("can't evaluate '" + expression + "'");
    }

    public String getBaseName() {
        return PathTools.getBaseName(this.file.getName(), this.extensionPrefix, "");
    }

    public String getExtension() {
        return PathTools.getExtension(this.file.getName(), this.extensionPrefix, "");
    }

    public File getFile() {
        return this.file;
    }

    public String getFileName() {
        return FileTools.getFileName(this.file);
    }

    public String getFullName() {
        return this.file.getAbsolutePath();
    }

    public String getPathName() {
        return FileTools.getPathName(this.file);
    }
}

