/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.TaggedStringExpression;
import de.intarsys.tools.expression.TaggedStringLiteral;
import de.intarsys.tools.expression.TaggedStringNode;
import de.intarsys.tools.expression.TaggedStringVariables;
import de.intarsys.tools.reader.DirectTagReader;
import de.intarsys.tools.reader.IDirectTagHandler;
import de.intarsys.tools.reader.ILocationProvider;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class TaggedStringParser {
    private boolean escape;
    private IDirectTagHandler handler = new IDirectTagHandler(){

        @Override
        public Object endTag(String tagContent, Object context) throws IOException {
            TaggedStringParser.this.processtag(tagContent, (List)context);
            return "";
        }

        @Override
        public void setLocationProvider(ILocationProvider location) {
        }

        @Override
        public void startTag() {
        }
    };
    private StringBuilder sb = new StringBuilder();

    public TaggedStringParser() {
        this(false);
    }

    public TaggedStringParser(boolean escape) {
        this.escape = escape;
    }

    public void declareVariables(TaggedStringVariables variables, String template) throws IOException {
        if (StringTools.isEmpty(template)) {
            return;
        }
        List<TaggedStringNode> nodes = this.parse(template);
        for (TaggedStringNode node : nodes) {
            String expr;
            if (!(node instanceof TaggedStringExpression) || variables.isDefined(expr = ((TaggedStringExpression)node).getExpression())) continue;
            variables.put(expr, "");
        }
    }

    public boolean isEscape() {
        return this.escape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaggedStringNode> parse(String expression) throws IOException {
        this.sb.setLength(0);
        ArrayList<TaggedStringNode> list = new ArrayList<TaggedStringNode>();
        StringReader base = new StringReader(expression);
        DirectTagReader reader = new DirectTagReader(base, this.handler, list, this.isEscape());
        try {
            int i = ((Reader)reader).read();
            while (i != -1) {
                this.sb.append((char)i);
                i = ((Reader)reader).read();
            }
            if (this.sb.length() > 0) {
                list.add(new TaggedStringLiteral(this.sb.toString()));
                this.sb.setLength(0);
            }
            ArrayList<TaggedStringNode> arrayList = list;
            return arrayList;
        }
        finally {
            StreamTools.close(reader);
        }
    }

    protected void processtag(String expression, List<TaggedStringNode> context) {
        if (this.sb.length() > 0) {
            context.add(new TaggedStringLiteral(this.sb.toString()));
            this.sb.setLength(0);
        }
        context.add(new TaggedStringExpression(expression));
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }
}

