/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.bean.IBeanInstallationInstruction;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.expression.ExpressionEvaluator;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.IAccessSupport;
import jakarta.annotation.PostConstruct;
import java.util.EnumSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionDefinition
implements IBeanInstallationInstruction {
    private static final Logger Log = LoggerFactory.getLogger(ExpressionDefinition.class);
    private String name;
    private Object value;
    private Set<Mode> modes;

    public ExpressionDefinition(String name, Object value) {
        this(name, value, EnumSet.allOf(Mode.class));
    }

    public ExpressionDefinition(String name, Object value, Mode firstMode, Mode ... moreModes) {
        this(name, value, EnumSet.of(firstMode, moreModes));
    }

    public ExpressionDefinition(String name, Object value, Set<Mode> modes) {
        this.name = name;
        this.value = value;
        this.modes = EnumSet.copyOf(modes);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    @PostConstruct
    public void install() {
        this.modes.forEach(this::install);
    }

    private void install(Mode mode) {
        IStringEvaluator resolver = ExpressionEvaluator.get(mode);
        if (resolver instanceof IAccessSupport) {
            IAccessSupport accessSupport = (IAccessSupport)((Object)resolver);
            try {
                accessSupport.setValue(this.getName(), this.getValue());
            }
            catch (FieldException e) {
                Log.warn("expression evaluator ({}) write error, cannot define {} ({})", new Object[]{mode, this.getName(), ExceptionTools.getMessage(e)});
            }
        } else {
            Log.warn("expression evaluator ({}) not writable, cannot define {}", (Object)mode, (Object)this.getName());
        }
    }
}

