/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.ContainerResolver;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;
import java.util.HashMap;
import java.util.Map;

public class EntityResolver
extends ContainerResolver {
    private static final Map<String, String> ENTITIES = new HashMap<String, String>();

    @Override
    protected Object basicEvaluate(String expression, IArgs args) throws EvaluationException {
        try {
            if (expression.startsWith("x")) {
                String code = expression.substring(1);
                int index = Integer.parseInt(code, 16);
                return new String(Character.toChars(index));
            }
            if (expression.startsWith("o")) {
                String code = expression.substring(1);
                int index = Integer.parseInt(code, 8);
                return new String(Character.toChars(index));
            }
            int index = Integer.parseInt(expression);
            return new String(Character.toChars(index));
        }
        catch (Exception e) {
            String value = ENTITIES.get(expression);
            if (value == null) {
                return this.notFound(expression);
            }
            return value;
        }
    }

    static {
        ENTITIES.put("amp", "&");
        ENTITIES.put("gt", ">");
        ENTITIES.put("lt", "<");
        ENTITIES.put("copy", "\u00a9");
        ENTITIES.put("trade", "\u2122");
        ENTITIES.put("cr", "\r");
        ENTITIES.put("lf", "\n");
        ENTITIES.put("quot", "\"");
        ENTITIES.put("squot", "'");
        ENTITIES.put("slash", "/");
        ENTITIES.put("backslash", "\\");
        ENTITIES.put("nl", StringTools.LS);
    }
}

