/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class CountersResolver
implements IStringEvaluator {
    private static final int MAX_CACHE_SIZE = 5000;
    private Map<String, Integer> counters = Collections.synchronizedMap(new LinkedHashMap<String, Integer>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Integer> eldest) {
            return this.size() > 5000;
        }
    });

    @Override
    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        return this.counters.compute(expression, (key, value) -> value == null ? 0 : value + 1);
    }
}

