/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.exception;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.exception.ErrorObjectFromThrowableConverter;

public class ErrorObject {
    private String code;
    private String message;
    private int status;

    public static ErrorObject create(Throwable t) {
        try {
            return ConverterRegistry.get().convert(t, ErrorObject.class);
        }
        catch (ConversionException e1) {
            return ErrorObjectFromThrowableConverter.ACTIVE.convert(t);
        }
    }

    public ErrorObject() {
    }

    public ErrorObject(String code, String message, int status) {
        this.code = code;
        this.message = message;
        this.status = status;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public int getStatus() {
        return this.status;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String toString() {
        return String.format("%s (code %s, status %d)", this.message, this.code, this.status);
    }
}

