/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.exception;

import de.intarsys.tools.exception.ICodeException;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;

public class EncodedRuntimeException
extends RuntimeException
implements ICodeException {
    private final String code;
    private final int status;

    public static EncodedRuntimeException create(IArgs args) {
        String code = ArgTools.getString(args, "error.code", "unknown");
        String message = ArgTools.getString(args, "error.message", "unexpected failure");
        return new EncodedRuntimeException(code, message);
    }

    public EncodedRuntimeException(int status, String code) {
        this.code = code;
        this.status = status;
    }

    public EncodedRuntimeException(int status, String code, String message) {
        super(message);
        this.code = code;
        this.status = status;
    }

    public EncodedRuntimeException(int status, String code, String message, Throwable cause) {
        super(message, cause);
        this.code = code;
        this.status = status;
    }

    public EncodedRuntimeException(int status, String code, Throwable cause) {
        super(cause);
        this.code = code;
        this.status = status;
    }

    public EncodedRuntimeException(String code) {
        this.code = code;
        this.status = 500;
    }

    public EncodedRuntimeException(String code, String message) {
        super(message);
        this.code = code;
        this.status = 500;
    }

    public EncodedRuntimeException(String code, String message, Throwable cause) {
        super(message, cause);
        this.code = code;
        this.status = 500;
    }

    public EncodedRuntimeException(String code, Throwable cause) {
        super(cause);
        this.code = code;
        this.status = 500;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public int getStatus() {
        return this.status;
    }
}

