/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.eventbus;

import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.eventbus.EventSourcePredicate;
import de.intarsys.tools.eventbus.IEventBus;
import de.intarsys.tools.eventbus.StandardEventSubscription;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class StandardEventBus
implements IEventBus {
    private final List<StandardEventSubscription> subscriptions = new CopyOnWriteArrayList<StandardEventSubscription>();
    private final List<INotificationSupport> sources = new ArrayList<INotificationSupport>();
    private final INotificationListener listenNotification = new INotificationListener(){

        public void handleEvent(Event event) {
            StandardEventBus.this.onNotification(event);
        }
    };
    private final Object lock = new Object();

    public void handleEvent(Event event) {
        for (StandardEventSubscription subscription : this.subscriptions) {
            if (!subscription.getSourcePredicate().accepts(event.getSource()) || event.getEventType() != subscription.getEventType() && subscription.getEventType() != EventType.ALWAYS) continue;
            subscription.getListener().handleEvent(event);
        }
    }

    protected void onNotification(Event event) {
        this.handleEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(INotificationSupport ns) {
        Object object = this.lock;
        synchronized (object) {
            this.sources.add(ns);
            ns.addNotificationListener(EventType.ALWAYS, this.listenNotification);
        }
    }

    @Override
    public void subscribe(EventSourcePredicate predicate, EventType type, INotificationListener listener) {
        StandardEventSubscription subscription = new StandardEventSubscription();
        subscription.setEventType(type);
        subscription.setListener(listener);
        subscription.setSourcePredicate(predicate);
        this.subscriptions.add(subscription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(INotificationSupport ns) {
        Object object = this.lock;
        synchronized (object) {
            this.sources.remove(ns);
            ns.removeNotificationListener(EventType.ALWAYS, this.listenNotification);
        }
    }
}

