/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.event;

import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import java.util.HashSet;
import java.util.Set;

public class NotificationSet {
    private final Set<NotificationEntry> armed = new HashSet<NotificationEntry>();
    private final Set<NotificationEntry> remaining = new HashSet<NotificationEntry>();

    public synchronized void arm(INotificationSupport object, EventType type, INotificationListener listener) {
        NotificationEntry newEntry = new NotificationEntry();
        newEntry.object = object;
        newEntry.type = type;
        newEntry.listener = listener;
        this.remaining.remove(newEntry);
        if (this.armed.contains(newEntry)) {
            return;
        }
        this.armed.add(newEntry);
        newEntry.arm();
    }

    public synchronized void disarm() {
        for (NotificationEntry entry : this.armed) {
            entry.disarm();
        }
        this.remaining.clear();
        this.armed.clear();
    }

    public synchronized void disarm(INotificationSupport object, EventType type, INotificationListener listener) {
        NotificationEntry newEntry = new NotificationEntry();
        newEntry.object = object;
        newEntry.type = type;
        newEntry.listener = listener;
        this.armed.remove(newEntry);
        this.remaining.remove(newEntry);
        newEntry.disarm();
    }

    public synchronized void disarmRemaining() {
        for (NotificationEntry entry : this.remaining) {
            entry.disarm();
            this.armed.remove(entry);
        }
        this.remaining.clear();
        this.remaining.addAll(this.armed);
    }

    static class NotificationEntry {
        protected INotificationSupport object;
        protected EventType type;
        protected INotificationListener listener;

        NotificationEntry() {
        }

        public void arm() {
            this.object.addNotificationListener(this.type, this.listener);
        }

        public void disarm() {
            this.object.removeNotificationListener(this.type, this.listener);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NotificationEntry)) {
                return false;
            }
            NotificationEntry other = (NotificationEntry)obj;
            return this.object.equals(other.object) && this.type.equals(other.type) && this.listener.equals(other.listener);
        }

        public int hashCode() {
            return this.object.hashCode() * 43 + this.listener.hashCode();
        }
    }
}

