/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.environment.file;

import de.intarsys.tools.component.Singleton;
import de.intarsys.tools.environment.file.IFileEnvironment;
import de.intarsys.tools.environment.file.StandardFileEnvironment;
import java.io.File;

@Singleton
public class FileEnvironment {
    protected static IFileEnvironment SharedEnvironment = new StandardFileEnvironment();
    protected static final ThreadLocal ENVIRONMENT = ThreadLocal.withInitial(() -> new IFileEnvironment(){

        @Override
        public File getBaseDir() {
            return FileEnvironment.getShared().getBaseDir();
        }

        @Override
        public File getDataDir() {
            return FileEnvironment.getShared().getDataDir();
        }

        @Override
        public File getProfileDir() {
            return FileEnvironment.getShared().getProfileDir();
        }

        @Override
        public File getTempDir() {
            return FileEnvironment.getShared().getTempDir();
        }

        @Override
        public File getWorkingDir() {
            return FileEnvironment.getShared().getWorkingDir();
        }
    });

    public static IFileEnvironment get() {
        return (IFileEnvironment)ENVIRONMENT.get();
    }

    public static synchronized IFileEnvironment getShared() {
        return SharedEnvironment;
    }

    public static void set(IFileEnvironment cc) {
        ENVIRONMENT.set(cc);
    }

    public static synchronized void setShared(IFileEnvironment cc) {
        SharedEnvironment = cc;
    }

    private FileEnvironment() {
    }
}

