/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.dom;

import de.intarsys.tools.dom.DOMTools;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.sax.ISAXElementHandler;
import de.intarsys.tools.sax.SAXAbstractElementHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SimpleDOMElementHandler
extends SAXAbstractElementHandler {
    private Node currentBranch;
    private Document document;
    private IStringEvaluator evaluator;
    private int nesting = 0;

    public SimpleDOMElementHandler() {
    }

    public SimpleDOMElementHandler(IStringEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endElement(String pUri, String local, String name) throws SAXException {
        --this.nesting;
        this.currentBranch = this.currentBranch.getParentNode();
        if (this.nesting == 0) {
            this.getContextHandler().setTemplateEvaluator(this.evaluator);
            this.evaluator = null;
        }
    }

    public Document getDocument() {
        return this.document;
    }

    protected IStringEvaluator getStringEvaluator() {
        return this.evaluator;
    }

    @Override
    public void initialize(String pUri, String local, String name, Attributes attrs) throws SAXException {
        if (this.nesting == 0) {
            this.evaluator = this.getContextHandler().getTemplateEvaluator();
            this.getContextHandler().setTemplateEvaluator(null);
        }
        ++this.nesting;
        if (this.document == null) {
            this.document = DOMTools.createDocument();
            Element root = this.document.createElement(local);
            int len = attrs.getLength();
            for (int i = 0; i < len; ++i) {
                root.setAttribute(attrs.getLocalName(i), attrs.getValue(i));
            }
            this.document.appendChild(root);
            this.currentBranch = root;
        }
    }

    @Override
    public void processAttributes(Attributes attrs) throws SAXException {
    }

    @Override
    public void reset() {
        this.document = null;
        this.currentBranch = null;
        this.nesting = 0;
        this.evaluator = null;
        super.reset();
    }

    @Override
    public ISAXElementHandler startElement(String pUri, String local, String name, Attributes attrs) throws SAXException {
        Element element = this.document.createElement(local);
        int len = attrs.getLength();
        for (int i = 0; i < len; ++i) {
            element.setAttribute(attrs.getLocalName(i), attrs.getValue(i));
        }
        this.currentBranch.appendChild(element);
        this.currentBranch = element;
        return this;
    }
}

