/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.digest;

import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.FunctorExecutionException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.locator.BasicLocatorFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestFunctor
implements IFunctor<Object> {
    public static final String ARG_ENCODING = "encoding";
    public static final String ARG_FORMAT = "format";
    public static final String ARG_ALGORITHM = "algorithm";
    public static final String ARG_LOCATOR = "locator";
    public static final String VALUE_ENCODING_NONE = "NONE";
    public static final String VALUE_ENCODING_BASE64 = "BASE64";
    public static final String VALUE_ENCODING_HEX = "HEX";
    public static final String VALUE_FORMAT_RAW = "RAW";
    public static final String VALUE_FORMAT_DER = "DER";
    private static final Logger Log = LoggerFactory.getLogger(DigestFunctor.class);

    public static String getAlgorithmName(IArgs args) {
        return ArgTools.getString(args, ARG_ALGORITHM, "SHA256");
    }

    public static IDigester getDigester(IArgs args) {
        String algName = DigestFunctor.getAlgorithmName(args);
        try {
            return DigestTools.createDigester(algName);
        }
        catch (NoSuchAlgorithmException e) {
            Log.error("Digest algorithm '" + algName + "' not supported. Using SHA1.", (Throwable)e);
            return DigestTools.createDigesterSHA1();
        }
    }

    public static String getEncoding(IArgs args) {
        return ArgTools.getString(args, ARG_ENCODING, VALUE_ENCODING_BASE64);
    }

    public static String getFormat(IArgs args) {
        return ArgTools.getString(args, ARG_FORMAT, VALUE_FORMAT_DER).toUpperCase();
    }

    public static ILocator getLocator(IArgs args) {
        return ArgTools.getLocator(args, ARG_LOCATOR, null, BasicLocatorFactory.get());
    }

    @Override
    public Object perform(IFunctorCall call) throws FunctorException {
        IArgs args = call.getArgs();
        ILocator locator = DigestFunctor.getLocator(args);
        if (locator == null) {
            throw new IllegalArgumentException("'locator' missing");
        }
        IDigester digester = DigestFunctor.getDigester(args);
        if (digester == null) {
            throw new IllegalArgumentException("'digester' missing");
        }
        InputStream is = null;
        try {
            Object result;
            byte[] bytes;
            is = locator.getInputStream();
            IDigest digest = DigestTools.digest(digester, is);
            String format = DigestFunctor.getFormat(args);
            if (VALUE_FORMAT_RAW.equals(format)) {
                bytes = digest.getBytes();
            } else if (VALUE_FORMAT_DER.equals(format)) {
                bytes = digest.getEncoded();
            } else {
                throw new IllegalArgumentException("'format' " + format + " not supported");
            }
            String encoding = DigestFunctor.getEncoding(args);
            if (VALUE_ENCODING_NONE.equals(encoding)) {
                result = bytes;
            } else if (VALUE_ENCODING_BASE64.equals(encoding)) {
                result = new String(Base64.encode(bytes));
            } else if (VALUE_ENCODING_HEX.equals(encoding)) {
                result = HexTools.bytesToHexString(bytes, 0, bytes.length, false);
            } else {
                throw new IllegalArgumentException("'encoding' " + encoding + " not supported");
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (IOException e) {
            throw new FunctorExecutionException(e);
        }
        finally {
            StreamTools.close(is);
        }
    }
}

