/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto;

import de.intarsys.tools.crypto.CryptoEnvironment;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.ICryptdec;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.string.CharacterTools;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;

public final class Secret {
    private static final String HASH = "#";
    public static final Secret EMPTY = new Secret(null, null);
    public static final String CHARS_SPECIAL = "!$%&/=?*+#-_";
    public static final String CHARS_DIGITS = "0123456879";
    public static final String CHARS_LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    public static final String CHARS_UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String CHARS_ALL = "0123456879abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!$%&/=?*+#-_";
    private final String id;
    private final String data;

    public static void clear(byte[] bytes) {
        Arrays.fill(bytes, (byte)0);
    }

    public static void clear(char[] chars) {
        Arrays.fill(chars, ' ');
    }

    public static Secret create(int length) {
        SecureRandom rand = CryptoTools.createSecureRandom();
        return Secret.create(length, CHARS_ALL, rand);
    }

    public static Secret create(int length, String validChars, Random random) {
        int size = validChars.length();
        char[] buff = new char[length];
        for (int i = 0; i < length; ++i) {
            buff[i] = validChars.charAt(random.nextInt(size));
        }
        return Secret.hide(buff);
    }

    public static Secret hide(byte[] value) {
        try {
            ICryptdec cryptdec = CryptoEnvironment.get().createDefaultCryptdecEncrypt();
            return Secret.hide(cryptdec, value);
        }
        catch (GeneralSecurityException e) {
            throw new InternalError("crypto environment not set up correctly", e);
        }
    }

    public static Secret hide(char[] value) {
        try {
            ICryptdec cryptdec = CryptoEnvironment.get().createDefaultCryptdecEncrypt();
            return Secret.hide(cryptdec, value);
        }
        catch (GeneralSecurityException e) {
            throw new InternalError("crypto environment not set up correctly", e);
        }
    }

    public static Secret hide(ICryptdec cryptdec, byte[] value) {
        try {
            if (value == null) {
                return new Secret(cryptdec.getId(), null);
            }
            if (value.length == 0) {
                return new Secret(cryptdec.getId(), "");
            }
            byte[] encrypted = cryptdec.encrypt(value);
            return new Secret(cryptdec.getId(), new String(Base64.encode(encrypted)));
        }
        catch (GeneralSecurityException e) {
            throw new InternalError("crypto environment not set up correctly", e);
        }
    }

    public static Secret hide(ICryptdec cryptdec, char[] value) {
        byte[] bytes = CharacterTools.toByteArrayUTF8(value);
        return Secret.hide(cryptdec, bytes);
    }

    public static Secret hideTrimmed(char[] value) {
        try {
            ICryptdec cryptdec = CryptoEnvironment.get().createDefaultCryptdecEncrypt();
            return Secret.hideTrimmed(cryptdec, value);
        }
        catch (GeneralSecurityException e) {
            throw new InternalError("crypto environment not set up correctly", e);
        }
    }

    public static Secret hideTrimmed(ICryptdec cryptdec, char[] value) {
        byte[] bytes = CharacterTools.toByteArrayUTF8(CharacterTools.trim(value));
        return Secret.hide(cryptdec, bytes);
    }

    public static Secret parse(String encoded) {
        return new Secret(encoded);
    }

    protected Secret(String encoded) {
        if (encoded == null) {
            this.id = null;
            this.data = null;
        } else {
            int index = encoded.indexOf(35);
            if (index < 0) {
                this.id = null;
                this.data = encoded;
            } else {
                this.id = encoded.substring(0, index);
                this.data = encoded.substring(index + 1);
            }
        }
    }

    protected Secret(String id, String data) {
        this.id = id;
        this.data = data;
    }

    public boolean equals(Object other) {
        if (other instanceof Secret) {
            try {
                Secret otherSecret = (Secret)other;
                byte[] bytes = this.getBytes();
                byte[] otherBytes = otherSecret.getBytes();
                return Arrays.equals(bytes, otherBytes);
            }
            catch (GeneralSecurityException e) {
                return false;
            }
        }
        return super.equals(other);
    }

    public byte[] getBytes() throws GeneralSecurityException {
        if (this.data == null) {
            return null;
        }
        if ("".equals(this.data)) {
            return new byte[0];
        }
        try {
            ICryptdec cryptdec = CryptoEnvironment.get().createCryptdec(this.id);
            byte[] bytes = Base64.decode(this.data);
            byte[] decrypted = cryptdec.decrypt(bytes);
            return decrypted;
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }

    public char[] getChars() throws GeneralSecurityException {
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            return null;
        }
        try {
            char[] cArray = CharacterTools.toCharArrayUTF8(bytes);
            return cArray;
        }
        finally {
            Arrays.fill(bytes, (byte)0);
        }
    }

    public String getEncoded() {
        if (StringTools.isEmpty(this.id)) {
            if (this.data == null) {
                return null;
            }
            if (StringTools.isEmpty(this.data)) {
                return "";
            }
            return this.data;
        }
        if (this.data == null) {
            return null;
        }
        if (StringTools.isEmpty(this.data)) {
            return this.id + HASH;
        }
        return this.id + HASH + this.data;
    }

    public String getString() throws GeneralSecurityException {
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            return null;
        }
        try {
            String string = StringTools.toStringUTF8(bytes);
            return string;
        }
        finally {
            Arrays.fill(bytes, (byte)0);
        }
    }

    public int hashCode() {
        if (StringTools.isEmpty(this.data)) {
            return 0;
        }
        return this.data.hashCode();
    }

    public boolean isEmpty() {
        return StringTools.isEmpty(this.data);
    }

    public String toString() {
        return this.getEncoded();
    }
}

