/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto;

import de.intarsys.tools.crypto.DynamicCryptdec;
import de.intarsys.tools.crypto.ICryptdec;
import de.intarsys.tools.crypto.PBCryptdecFactory;
import de.intarsys.tools.crypto.Secret;
import java.security.GeneralSecurityException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class DynamicPBAES128CryptdecFactory
extends PBCryptdecFactory {
    private SecretKey key;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicPBAES128CryptdecFactory(String id, Secret password, byte[] salt, int iterationCount) throws GeneralSecurityException {
        super(id);
        SecretKeyFactory pbKeyFactory = SecretKeyFactory.getInstance(this.getPBKeyFactoryId());
        PBEKeySpec pbKeySpec = new PBEKeySpec(password.getChars(), salt, iterationCount, this.getKeyLength());
        try {
            SecretKey pbSecret = pbKeyFactory.generateSecret(pbKeySpec);
            this.key = new SecretKeySpec(pbSecret.getEncoded(), this.getCipherAlgorithmId());
        }
        finally {
            pbKeySpec.clearPassword();
        }
    }

    @Override
    public ICryptdec createCryptdec() throws GeneralSecurityException {
        return new DynamicCryptdec(this.getId(), this.getKey(), this.getCipherId());
    }

    protected String getCipherAlgorithmId() {
        return "AES";
    }

    protected String getCipherId() {
        return "AES/CBC/PKCS5Padding";
    }

    private SecretKey getKey() {
        return this.key;
    }

    protected int getKeyLength() {
        return 128;
    }

    protected String getPBKeyFactoryId() {
        return "PBKDF2WithHmacSHA1";
    }
}

