/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto;

import de.intarsys.tools.component.SingletonClass;
import de.intarsys.tools.crypto.ICryptdec;
import de.intarsys.tools.crypto.ICryptdecFactory;
import de.intarsys.tools.crypto.NullCryptdecFactory;
import de.intarsys.tools.string.CharacterTools;
import de.intarsys.tools.string.StringTools;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SingletonClass
public class CryptoEnvironment {
    private static final CryptoEnvironment ACTIVE = new CryptoEnvironment();
    private static final Logger Log = LoggerFactory.getLogger(CryptoEnvironment.class);
    private Map<String, ICryptdecFactory> factories = new HashMap<String, ICryptdecFactory>();
    private ICryptdecFactory defaultCryptdecFactoryEncrypt;
    private ICryptdecFactory defaultCryptdecFactoryDecrypt;

    public static CryptoEnvironment get() {
        return ACTIVE;
    }

    private CryptoEnvironment() {
        this.reset();
    }

    public ICryptdec createCryptdec(String id) throws GeneralSecurityException {
        if (StringTools.isEmpty(id)) {
            return this.createDefaultCryptdecDecrypt();
        }
        ICryptdecFactory factory = this.lookupCryptdecFactory(id);
        if (factory == null) {
            throw new GeneralSecurityException("unsupported cryptdec " + id);
        }
        return factory.createCryptdec();
    }

    protected ICryptdec createDefaultCryptdecDecrypt() throws GeneralSecurityException {
        if (this.defaultCryptdecFactoryDecrypt == null) {
            throw new GeneralSecurityException("default cryptdec not defined");
        }
        return this.defaultCryptdecFactoryDecrypt.createCryptdec();
    }

    protected ICryptdec createDefaultCryptdecEncrypt() throws GeneralSecurityException {
        if (this.defaultCryptdecFactoryEncrypt == null) {
            throw new GeneralSecurityException("default cryptdec not defined");
        }
        return this.defaultCryptdecFactoryEncrypt.createCryptdec();
    }

    public byte[] decryptBytes(byte[] bytes) throws GeneralSecurityException {
        return this.decryptBytes(bytes, null);
    }

    public byte[] decryptBytes(byte[] bytes, ICryptdec cryptdec) throws GeneralSecurityException {
        if (bytes == null) {
            return null;
        }
        if (cryptdec == null) {
            cryptdec = this.createDefaultCryptdecDecrypt();
        }
        return cryptdec.decrypt(bytes);
    }

    public char[] decryptChars(byte[] value) throws GeneralSecurityException {
        return this.decryptChars(value, null);
    }

    public char[] decryptChars(byte[] value, ICryptdec cryptdec) throws GeneralSecurityException {
        if (value == null) {
            return null;
        }
        byte[] decrypted = this.decryptBytes(value, cryptdec);
        return CharacterTools.toCharArrayUTF8(decrypted);
    }

    public byte[] encryptBytes(byte[] bytes) throws GeneralSecurityException {
        return this.encryptBytes(bytes, null);
    }

    public byte[] encryptBytes(byte[] bytes, ICryptdec cryptdec) throws GeneralSecurityException {
        if (bytes == null) {
            return null;
        }
        if (cryptdec == null) {
            cryptdec = this.createDefaultCryptdecEncrypt();
        }
        return cryptdec.encrypt(bytes);
    }

    public byte[] encryptChars(char[] value) throws GeneralSecurityException {
        return this.encryptChars(value, null);
    }

    public byte[] encryptChars(char[] value, ICryptdec cryptdec) throws GeneralSecurityException {
        if (value == null) {
            return null;
        }
        return this.encryptBytes(CharacterTools.toByteArrayUTF8(value), cryptdec);
    }

    public Collection<ICryptdecFactory> getCryptdecFactories() {
        return this.factories.values();
    }

    public ICryptdecFactory getDefaultCryptdecFactoryDecrypt() {
        return this.defaultCryptdecFactoryDecrypt;
    }

    public ICryptdecFactory getDefaultCryptdecFactoryEncrypt() {
        return this.defaultCryptdecFactoryEncrypt;
    }

    public ICryptdecFactory lookupCryptdecFactory(String id) {
        return this.factories.get(id);
    }

    public void registerCryptdecFactory(ICryptdecFactory factory) {
        if (this.factories.containsKey(factory.getId())) {
            Log.warn("{} can't redefine cryptdec '{}'", (Object)this, (Object)factory.getId());
            return;
        }
        this.factories.put(factory.getId(), factory);
    }

    protected void reset() {
        this.defaultCryptdecFactoryDecrypt = null;
        this.defaultCryptdecFactoryEncrypt = null;
        this.factories.clear();
        NullCryptdecFactory plain = new NullCryptdecFactory("plain");
        this.registerCryptdecFactory(plain);
        this.setDefaultCryptdecFactoryDecrypt(plain);
        this.setDefaultCryptdecFactoryEncrypt(plain);
    }

    public void setDefaultCryptdecFactoryDecrypt(ICryptdecFactory factory) {
        if (this.defaultCryptdecFactoryDecrypt != null && !(this.defaultCryptdecFactoryDecrypt instanceof NullCryptdecFactory)) {
            Log.warn("{} can't redefine cryptdec '{}'", (Object)this, (Object)factory.getId());
            return;
        }
        this.defaultCryptdecFactoryDecrypt = factory;
    }

    public void setDefaultCryptdecFactoryEncrypt(ICryptdecFactory factory) {
        if (this.defaultCryptdecFactoryEncrypt != null && !(this.defaultCryptdecFactoryEncrypt instanceof NullCryptdecFactory)) {
            Log.warn("{} can't redefine cryptdec '{}'", (Object)this, (Object)factory.getId());
            return;
        }
        this.defaultCryptdecFactoryEncrypt = factory;
    }
}

