/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto;

import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.ISecretStore;
import de.intarsys.tools.crypto.Secret;
import java.util.ArrayList;
import java.util.List;

public class CompositeSecretStore
implements ISecretStore {
    private final List<ISecretStore> stores = new ArrayList<ISecretStore>();

    public void addSecretStore(ISecretStore store) {
        this.stores.add(store);
    }

    @Override
    public void clearSecret(String id) {
        for (ISecretStore store : this.stores) {
            store.clearSecret(id);
        }
    }

    @Override
    public void clearSecrets() {
        for (ISecretStore store : this.stores) {
            store.clearSecrets();
        }
    }

    @Override
    public Secret getSecret(String id) {
        for (ISecretStore store : this.stores) {
            Secret secret = store.getSecret(id);
            if (CryptoTools.isEmpty(secret)) continue;
            return secret;
        }
        return Secret.EMPTY;
    }

    @Override
    public boolean isPersistent(String id) {
        for (ISecretStore store : this.stores) {
            if (!store.isPersistent(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setSecret(String id, Secret secret, boolean persistent) {
        for (ISecretStore store : this.stores) {
            try {
                store.setSecret(id, secret, persistent);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        throw new UnsupportedOperationException();
    }
}

