/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.collection;

import de.intarsys.tools.collection.CommonBuilder;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.reader.ReaderTools;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class MapTools {
    private static final String TERMINATOR = ";";
    public static final String SEPARATOR = "=";

    public static Map applyDeep(Map map, Function<IArgs.IBinding, Object> function) {
        for (Map.Entry entry : map.entrySet()) {
            LangTools.applyDeep(entry.getValue(), function, new MapBinding(entry));
        }
        return map;
    }

    public static <K, V> Builder<K, V> builder() {
        return MapTools.builder(new HashMap());
    }

    public static <K, V> Builder<K, V> builder(Map<K, V> map) {
        return new Builder(null, map);
    }

    public static Map copyDeep(Map map) {
        if (map == null) {
            return null;
        }
        LinkedHashMap result = new LinkedHashMap(map.size());
        for (Map.Entry entry : map.entrySet()) {
            result.put(entry.getKey(), LangTools.copyDeep(entry.getValue()));
        }
        return result;
    }

    public static Map defineEntries(Map map, List<String> declarations) {
        if (declarations == null) {
            return map;
        }
        Iterator<String> i = declarations.iterator();
        while (i.hasNext()) {
            MapTools.defineEntries(map, i.next());
        }
        return map;
    }

    public static Map defineEntries(Map map, String definition) {
        if (StringTools.isEmpty(definition)) {
            return map;
        }
        StringReader r = new StringReader(definition);
        try {
            Map.Entry<String, String> entry;
            while ((entry = ReaderTools.readEntry(r, ';')) != null) {
                if (entry.getKey() == null) continue;
                map.put(entry.getKey(), entry.getValue());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return map;
    }

    public static Map<String, Object> flatten(Map<String, Object> map) {
        return MapTools.flatten(map, null, new HashMap<String, Object>());
    }

    public static Map flatten(Map<String, Object> map, String prefix, Map<String, Object> target) {
        if (map == null) {
            return null;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value;
            Object key = entry.getKey();
            if (!StringTools.isEmpty(prefix)) {
                key = prefix + "." + (String)key;
            }
            if ((value = entry.getValue()) instanceof Map) {
                MapTools.flatten((Map)value, (String)key, target);
                continue;
            }
            target.put((String)key, value);
        }
        return target;
    }

    public static Object get(Map map, Object key, Object defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static String get(Map map, Object key, String defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    public static Object getPath(Map map, String path, Object defaultValue) {
        int position;
        if (map == null) {
            return null;
        }
        if (StringTools.isEmpty(path) || ".".equals(path)) {
            return map;
        }
        String[] segments = path.split("\\.");
        for (position = 0; position < segments.length - 1; ++position) {
            Object tempValue = MapTools.get(map, (Object)segments[position], defaultValue);
            if (!(tempValue instanceof Map)) {
                return null;
            }
            map = (Map)tempValue;
        }
        return MapTools.get(map, (Object)segments[position], defaultValue);
    }

    public static String toStringDeep(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder();
        MapTools.toStringDeep(map, null, sb);
        return sb.toString();
    }

    public static void toStringDeep(Map<String, ?> map, String prefix, StringBuilder sb) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Object value;
            Object key = entry.getKey();
            if (!StringTools.isEmpty(prefix)) {
                key = prefix + "." + (String)key;
            }
            if ((value = entry.getValue()) instanceof Map) {
                MapTools.toStringDeep((Map)value, (String)key, sb);
                continue;
            }
            sb.append((String)key);
            sb.append(SEPARATOR);
            sb.append(StringTools.quote(String.valueOf(value)));
            sb.append(TERMINATOR);
        }
    }

    public static Map<?, ?> with(Object ... objects) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (int i = 0; i < objects.length; i += 2) {
            result.put(objects[i], objects[i + 1]);
        }
        return result;
    }

    private MapTools() {
    }

    public static class MapBinding
    implements IArgs.IBinding {
        private final Map.Entry entry;

        public MapBinding(Map.Entry entry) {
            this.entry = entry;
        }

        @Override
        public String getName() {
            return (String)this.entry.getKey();
        }

        @Override
        public Object getValue() {
            return this.entry.getValue();
        }

        @Override
        public boolean isDefined() {
            return true;
        }

        @Override
        public void setName(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValue(Object value) {
            this.entry.setValue(value);
        }
    }

    public static class Builder<K, V>
    extends CommonBuilder {
        private Map<K, V> map;

        protected Builder(CommonBuilder parent, Map map) {
            super(parent);
            this.map = map;
        }

        @Override
        public Map<K, V> build() {
            return this.map;
        }

        public Builder<K, V> put(K key, V value) {
            this.map.put(key, value);
            return this;
        }

        public ListTools.Builder startList(final K key) {
            return new ListTools.Builder(this, new ArrayList()){

                @Override
                public CommonBuilder end() {
                    this.put(key, this.build());
                    return super.end();
                }
            };
        }

        public Builder startMap(final K key) {
            return new Builder(this, new HashMap()){

                @Override
                public CommonBuilder end() {
                    this.put(key, this.build());
                    return super.end();
                }
            };
        }
    }
}

