/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.category;

import de.intarsys.tools.category.GenericCategory;
import de.intarsys.tools.category.ICategory;
import de.intarsys.tools.category.ICategoryRegistry;
import de.intarsys.tools.category.PACKAGE;
import de.intarsys.tools.lang.Aliases;
import de.intarsys.tools.message.IMessageBundle;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardCategoryRegistry
implements ICategoryRegistry {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(StandardCategoryRegistry.class);
    public static final GenericCategory OTHER;
    public static final GenericCategory UNKNOWN;
    private Map<String, ICategory> categories = new HashMap<String, ICategory>();

    public StandardCategoryRegistry() {
        this.registerCategory(UNKNOWN);
        this.registerCategory(OTHER);
    }

    @Override
    public ICategory[] getCategories() {
        return this.categories.values().toArray(new ICategory[this.categories.size()]);
    }

    @Override
    public ICategory lookupCategory(String id) {
        ICategory result = this.categories.get(Aliases.get().resolve(id));
        if (result == null) {
            result = UNKNOWN;
        }
        return result;
    }

    @Override
    public void registerCategory(ICategory category) {
        ICategory previous = this.categories.put(category.getId(), category);
        if (previous != null) {
            Log.warn("category {} is redefined", (Object)category.getId());
        }
    }

    public int size() {
        return this.categories.size();
    }

    static {
        UNKNOWN = new GenericCategory();
        UNKNOWN.setId("de.intarsys.category.unknown");
        UNKNOWN.setMessageBundle(Msg);
        OTHER = new GenericCategory();
        OTHER.setId("de.intarsys.category.other");
        OTHER.setMessageBundle(Msg);
    }
}

