/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.category;

import de.intarsys.tools.category.CategoryRegistry;
import de.intarsys.tools.category.ICategory;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IContextSupport;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.lang.Aliases;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.IMessageBundleSupport;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.presentation.PresentationMixin;
import de.intarsys.tools.reflect.IClassLoaderSupport;
import jakarta.annotation.PostConstruct;

public class GenericCategory
implements ICategory,
IPresentationSupport,
IElementConfigurable,
IClassLoaderSupport,
IContextSupport {
    private IElement element;
    private PresentationMixin presentation = new PresentationMixin(this);
    private String id;
    private String parentId;
    private ClassLoader classLoader;

    public GenericCategory() {
    }

    public GenericCategory(String id) {
        this.id = id;
    }

    @Override
    public void configure(IElement pElement) throws ConfigurationException {
        this.element = pElement;
        String tmpId = this.element.attributeValue("id", this.getId());
        tmpId = Aliases.get().resolve(tmpId);
        if (tmpId == null) {
            throw new ConfigurationException("category needs an id");
        }
        this.setId(tmpId);
        this.parentId = this.element.attributeValue("parent", null);
        this.parentId = Aliases.get().resolve(this.parentId);
        this.presentation.configure(pElement);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public String getDescription() {
        return this.presentation.getDescription();
    }

    public IElement getElement() {
        return this.element;
    }

    @Override
    public String getIconName() {
        return this.presentation.getIconName();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.presentation.getLabel();
    }

    public IMessageBundle getMessageBundle() {
        return this.presentation.getMessageBundle();
    }

    @Override
    public ICategory getParent() {
        return CategoryRegistry.get().lookupCategory(this.getParentId());
    }

    public String getParentId() {
        return this.parentId;
    }

    @Override
    public String getTip() {
        return this.presentation.getTip();
    }

    @PostConstruct
    public void register() {
        CategoryRegistry.get().registerCategory(this);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void setContext(Object context) throws ConfigurationException {
        if (context instanceof IMessageBundleSupport) {
            this.setMessageBundle(((IMessageBundleSupport)context).getMessageBundle());
        }
        if (context instanceof IClassLoaderSupport) {
            this.setClassLoader(((IClassLoaderSupport)context).getClassLoader());
        }
    }

    public void setDescription(Object description) {
        this.presentation.setDescription(description);
    }

    public void setElement(IElement element) {
        this.element = element;
    }

    public void setIconName(Object iconName) {
        this.presentation.setIconName(iconName);
    }

    public void setId(String id) {
        this.id = id;
        this.presentation.setCodePrefix(id);
    }

    public void setLabel(Object label) {
        this.presentation.setLabel(label);
    }

    public void setMessageBundle(IMessageBundle messageBundle) {
        this.presentation.setMessageBundle(messageBundle);
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void setTip(Object tip) {
        this.presentation.setTip(tip);
    }
}

