/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.application;

import de.intarsys.tools.application.ApplicationComponent;
import de.intarsys.tools.component.VersionTools;
import de.intarsys.tools.infoset.IElement;

public final class ApplicationComponentTools {
    public static final String CONFIG_CLASS = "class";
    public static final String CONFIG_FAMILY = "family";
    public static final String CONFIG_NAME = "name";
    public static final String CONFIG_LABEL = "label";

    public static void configure(ApplicationComponent app, IElement configuration) {
        String clazz = configuration.attributeValue(CONFIG_CLASS, app.getApplicationClass());
        String family = configuration.attributeValue(CONFIG_FAMILY, app.getApplicationFamily());
        String name = configuration.attributeValue(CONFIG_NAME, app.getName());
        String label = configuration.attributeValue(CONFIG_LABEL, app.getLabel());
        app.setApplicationClass(clazz);
        app.setApplicationFamily(family);
        app.setName(name);
        app.setLabel(label);
    }

    public static Object getValue(ApplicationComponent component, String name) {
        if (CONFIG_LABEL.equals(name)) {
            return component.getLabel();
        }
        if (CONFIG_NAME.equals(name)) {
            return component.getName();
        }
        if (CONFIG_FAMILY.equals(name)) {
            return component.getApplicationFamily();
        }
        if ("timestamp".equals(name)) {
            return component.getTimestamp();
        }
        if ("build".equals(name)) {
            return component.getBuild();
        }
        if ("version".equals(name)) {
            return component.getVersion();
        }
        if ("major".equals(name)) {
            String version = component.getVersion();
            return VersionTools.getMajor(version);
        }
        if ("micro".equals(name)) {
            String version = component.getVersion();
            return VersionTools.getMicro(version);
        }
        if ("minor".equals(name)) {
            String version = component.getVersion();
            return VersionTools.getMinor(version);
        }
        throw new IllegalArgumentException("field " + name + " not supported");
    }

    private ApplicationComponentTools() {
    }
}

