/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.application;

import de.intarsys.tools.component.ComponentInfo;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationComponent
extends ComponentInfo {
    private static final Logger Log = LoggerFactory.getLogger(ApplicationComponent.class);
    private static ApplicationComponent ACTIVE = new ApplicationComponent();
    private String applicationClass;
    private String applicationFamily;

    public static final ApplicationComponent get() {
        return ACTIVE;
    }

    public String getApplicationClass() {
        return this.applicationClass;
    }

    public String getApplicationFamily() {
        return this.applicationFamily;
    }

    public String prefixProperty(String name) {
        return this.getApplicationFamily() + "." + name;
    }

    public void read() {
        String productClassName = this.getApplicationClass();
        try {
            if (!StringTools.isEmpty(productClassName)) {
                Class<Object> productClass = ClassTools.createClass(productClassName, Object.class, null);
                this.readFromClass(productClass);
            }
        }
        catch (ObjectCreationException e) {
            Log.warn("cannot read meta information for '{}'", (Object)productClassName, (Object)e);
        }
    }

    public void setApplicationClass(String applicationClass) {
        this.applicationClass = applicationClass;
    }

    public void setApplicationFamily(String applicationFamily) {
        this.applicationFamily = applicationFamily;
    }
}

