/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.activity;

import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.activity.IActivityView;
import de.intarsys.tools.activity.IPrompter;
import de.intarsys.tools.activity.Requester;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.message.IMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestPassword<P extends IActivity<?>>
extends Requester<Secret, P> {
    private static final Logger Log = LoggerFactory.getLogger(RequestPassword.class);

    public static RequestPassword<?> create(IActivity<?> parent, IMessage title, IMessage message) {
        RequestPassword activity = new RequestPassword(parent);
        activity.setTitle(title);
        activity.setMessage(message);
        activity.setModal(true);
        return activity;
    }

    public static Secret requestPassword(IActivity<?> parent, IMessage title, IMessage message) {
        RequestPassword<?> activity = RequestPassword.create(parent, title, message);
        IActivityView view = activity.enter();
        if (view != null && !view.isConcurrent()) {
            view.cancel();
        }
        return (Secret)activity.getAnyway();
    }

    public RequestPassword(P parent) {
        super(parent);
    }

    @Override
    protected Secret getAnywayFailure() {
        return Secret.EMPTY;
    }

    public static class PasswordProvider
    implements IPasswordProvider,
    IPrompter {
        private IMessage title;
        private IMessage message;

        public IMessage getMessage() {
            return this.message;
        }

        @Override
        public Secret getPassword() {
            Log.debug("enter PIN start");
            try {
                Secret secret = RequestPassword.requestPassword(null, this.title, this.message);
                return secret;
            }
            finally {
                Log.debug("enter PIN ready");
            }
        }

        public IMessage getTitle() {
            return this.title;
        }

        @Override
        public void setMessage(IMessage message) {
            this.message = message;
        }

        @Override
        public void setTitle(IMessage title) {
            this.title = title;
        }
    }
}

