/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.activity;

import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.activity.IActivityHandler;
import de.intarsys.tools.activity.IActivityView;
import de.intarsys.tools.concurrent.ITaskCallback;
import de.intarsys.tools.concurrent.TaskFailed;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.exception.ExceptionTools;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ActivityLifecycleMonitor
implements IActivityHandler {
    private static final Logger Log = LoggerFactory.getLogger(ActivityLifecycleMonitor.class);
    private boolean active = true;
    private boolean synchronous;

    protected void activityChanged(IActivity<?> activity, AttributeChangedEvent event) {
        if (!this.isActive()) {
            return;
        }
        this.submitActivityChanged(activity, event);
    }

    @Override
    public <R> IActivityView activityEnter(final IActivity<R> activity) {
        if (!this.isActive()) {
            return null;
        }
        if (activity instanceof INotificationSupport) {
            ((INotificationSupport)((Object)activity)).addNotificationListener(AttributeChangedEvent.ID, new INotificationListener<AttributeChangedEvent>(){

                @Override
                public void handleEvent(AttributeChangedEvent event) {
                    ActivityLifecycleMonitor.this.activityChanged(activity, event);
                }
            });
        }
        activity.addTaskCallback(new ITaskCallback<R>(){

            @Override
            public void failed(TaskFailed exception) {
                try {
                    ActivityLifecycleMonitor.this.activityFailed(activity);
                }
                finally {
                    ActivityLifecycleMonitor.this.activityFinally(activity);
                }
            }

            @Override
            public void finished(R result) {
                try {
                    ActivityLifecycleMonitor.this.activityFinished(activity);
                }
                finally {
                    ActivityLifecycleMonitor.this.activityFinally(activity);
                }
            }
        });
        Future task = this.submitActivityEnter(activity);
        if (task != null && this.isSynchronous()) {
            ExceptionTools.futureSimpleGet(task);
        }
        return null;
    }

    protected void activityFailed(IActivity<?> activity) {
        if (!this.isActive()) {
            return;
        }
        this.submitActivityFailed(activity);
    }

    protected void activityFinally(IActivity<?> activity) {
        if (!this.isActive()) {
            return;
        }
        Future task = this.submitActivityFinally(activity);
        if (task != null && this.isSynchronous()) {
            ExceptionTools.futureSimpleGet(task);
        }
    }

    protected void activityFinished(IActivity<?> activity) {
        if (!this.isActive()) {
            return;
        }
        this.submitActivityFinished(activity);
    }

    protected void doActivityChanged(IActivity<?> activity, AttributeChangedEvent event) {
    }

    protected void doActivityEnter(IActivity<?> activity) {
    }

    protected void doActivityFailed(IActivity<?> activity) {
    }

    protected void doActivityFinally(IActivity<?> activity) {
    }

    protected void doActivityFinished(IActivity<?> activity) {
    }

    protected String getLogLabel() {
        return "activity monitor " + this.hashCode();
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    protected Future submit(Runnable r) {
        return null;
    }

    protected Future submitActivityChanged(final IActivity<?> activity, final AttributeChangedEvent event) {
        Future task = this.submit(new Runnable(){

            @Override
            public void run() {
                if (!ActivityLifecycleMonitor.this.isActive()) {
                    return;
                }
                Log.trace("{} {}", (Object)ActivityLifecycleMonitor.this.getLogLabel(), (Object)this);
                ActivityLifecycleMonitor.this.doActivityChanged(activity, event);
            }

            public String toString() {
                return "activityChanged " + activity;
            }
        });
        return task;
    }

    protected <R> Future submitActivityEnter(final IActivity<R> activity) {
        Future task = this.submit(new Runnable(){

            @Override
            public void run() {
                if (!ActivityLifecycleMonitor.this.isActive()) {
                    return;
                }
                Log.trace("{} {}", (Object)ActivityLifecycleMonitor.this.getLogLabel(), (Object)this);
                ActivityLifecycleMonitor.this.doActivityEnter(activity);
            }

            public String toString() {
                return "activityEnter " + activity;
            }
        });
        return task;
    }

    protected Future submitActivityFailed(final IActivity<?> activity) {
        Future task = this.submit(new Runnable(){

            @Override
            public void run() {
                if (!ActivityLifecycleMonitor.this.isActive()) {
                    return;
                }
                Log.trace("{} {}", (Object)ActivityLifecycleMonitor.this.getLogLabel(), (Object)this);
                ActivityLifecycleMonitor.this.doActivityFailed(activity);
            }

            public String toString() {
                return "activityFailed " + activity;
            }
        });
        return task;
    }

    protected Future submitActivityFinally(final IActivity<?> activity) {
        Future task = this.submit(new Runnable(){

            @Override
            public void run() {
                if (!ActivityLifecycleMonitor.this.isActive()) {
                    return;
                }
                Log.trace("{} {}", (Object)ActivityLifecycleMonitor.this.getLogLabel(), (Object)this);
                ActivityLifecycleMonitor.this.doActivityFinally(activity);
            }

            public String toString() {
                return "activityFinally " + activity;
            }
        });
        return task;
    }

    protected Future submitActivityFinished(final IActivity<?> activity) {
        Future task = this.submit(new Runnable(){

            @Override
            public void run() {
                if (!ActivityLifecycleMonitor.this.isActive()) {
                    return;
                }
                Log.trace("{} {}", (Object)ActivityLifecycleMonitor.this.getLogLabel(), (Object)this);
                ActivityLifecycleMonitor.this.doActivityFinished(activity);
            }

            public String toString() {
                return "activityFinished " + activity;
            }
        });
        return task;
    }
}

