/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.cli;

import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.cli.CLIException;
import de.intarsys.tools.cli.CLIOptionDescriptor;
import de.intarsys.tools.cli.ICLIOption;
import de.intarsys.tools.cli.ICLIOptionDescriptor;
import de.intarsys.tools.cli.ICLIOptionProcessor;
import de.intarsys.tools.cli.ICLIProcessor;

public abstract class CommonCLIOptionProcessor
implements ICLIOptionDescriptor,
ICLIOptionProcessor {
    public static final Attribute ATTR_PROCESSORARGS = new Attribute("processorArguments");

    protected CommonCLIOptionProcessor() {
    }

    public boolean canProcessArgument(String arg) {
        return false;
    }

    protected void checkEmpty(ICLIProcessor cliProcessor) throws CLIException {
        if (cliProcessor.isEmpty()) {
            cliProcessor.setResultCode(2);
            throw new CLIException("cli context is empty");
        }
    }

    protected void dup(ICLIProcessor cliProcessor) throws CLIException {
        this.checkEmpty(cliProcessor);
        this.push(cliProcessor, cliProcessor.peek());
    }

    @Override
    public String getLongOpt() {
        return this.getOptionDescriptor().getLongOpt();
    }

    @Override
    public String getOpt() {
        return this.getOptionDescriptor().getOpt();
    }

    public abstract CLIOptionDescriptor getOptionDescriptor();

    @Override
    public ICLIOptionProcessor getOptionProcessor() {
        return this;
    }

    @Override
    public void initOption(ICLIProcessor cliProcessor, ICLIOption option) throws CLIException {
    }

    @Override
    public boolean isMainOption() {
        return false;
    }

    protected Object peek(ICLIProcessor cliProcessor, Class expectedType) throws CLIException {
        this.checkEmpty(cliProcessor);
        Object operand = cliProcessor.peek();
        if (!expectedType.isInstance(operand)) {
            cliProcessor.setResultCode(10);
            throw new CLIException("cli context not of expected type");
        }
        return operand;
    }

    protected Object pop(ICLIProcessor cliProcessor, Class expectedType) throws CLIException {
        this.checkEmpty(cliProcessor);
        Object operand = cliProcessor.pop();
        if (!expectedType.isInstance(operand)) {
            cliProcessor.setResultCode(10);
            throw new CLIException("cli context not of expected type");
        }
        return operand;
    }

    protected void push(ICLIProcessor cliProcessor, Object operand) {
        cliProcessor.push(operand);
    }
}

