/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.cli;

import de.intarsys.tools.cli.CLICommandlineParser;
import de.intarsys.tools.cli.CLIOption;
import de.intarsys.tools.cli.ICLICommandline;
import de.intarsys.tools.cli.ICLIOption;
import de.intarsys.tools.collection.ArrayTools;
import de.intarsys.tools.component.Singleton;
import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.ExpressionEvaluator;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.StaticArgEntriesResolver;
import de.intarsys.tools.expression.StaticArgsResolver;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.url.URLEncodingTools;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@Singleton
public class CLICommandline
implements ICLICommandline {
    private static ICLICommandline Active;
    private static final String CLIOPT_CF = "cf";
    private static final String CLIOPT_COMMANDFILE = "commandfile";
    private static final String SEPARATOR = "=";
    private static final Logger Log;
    public static final String RESOLVER_OPTIONS = "options";
    public static final String RESOLVER_OPTIONENTRIES = "optionEntries";
    private String[] args;
    private List<ICLIOption> options = new ArrayList<ICLIOption>();
    private boolean processed = false;
    private List<String> remaining = new ArrayList<String>();

    public static ICLICommandline createCommandLine(String[] args) {
        CLICommandlineParser parser = new CLICommandlineParser();
        ICLICommandline localCommandline = parser.parse(args);
        ICLICommandline fileCommandLine = CLICommandline.processCommandFile(localCommandline);
        if (fileCommandLine != null) {
            return fileCommandLine;
        }
        return localCommandline;
    }

    public static ICLICommandline get() {
        return Active;
    }

    protected static ICLICommandline parseCommandFile(File file, ICLIOption commandFileOption) {
        if (!file.isAbsolute()) {
            file = new File(FileEnvironment.get().getBaseDir(), file.getPath());
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("command file '" + file.getPath() + "' does not exist");
        }
        try {
            Args cliOptions = Args.create();
            String[] optionValues = commandFileOption.getValues();
            for (int i = 0; i < optionValues.length; ++i) {
                String optionValue = optionValues[i];
                if (StringTools.isEmpty((String)optionValue)) continue;
                String[] split = optionValue.split(SEPARATOR);
                if (split.length < 2) {
                    cliOptions.add((Object)split[0]);
                    continue;
                }
                cliOptions.put(split[0], (Object)split[1]);
            }
            if (Log.isEnabledForLevel(Level.DEBUG)) {
                Log.debug("Stage load command line from '" + file.getPath() + "'");
            }
            String fileContent = FileTools.getString((File)file);
            MapResolver resolver = MapResolver.createStrict().put(RESOLVER_OPTIONS, (Object)new StaticArgsResolver((IArgs)cliOptions)).put(RESOLVER_OPTIONENTRIES, (Object)new StaticArgEntriesResolver((IArgs)cliOptions));
            TaggedStringEvaluator evaluator = TaggedStringEvaluator.decorateLenient((IStringEvaluator[])new IStringEvaluator[]{resolver, ExpressionEvaluator.get((Mode)Mode.TRUSTED)});
            fileContent = (String)evaluator.evaluate(fileContent, (IArgs)Args.create());
            String[] fileArgs = StringTools.parseCommandline((String)fileContent);
            if (fileArgs == null) {
                return null;
            }
            return new CLICommandlineParser().parse(fileArgs);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("command file '" + file.getPath() + "' can not be read", e);
        }
        catch (EvaluationException e) {
            throw new IllegalArgumentException("command file '" + file.getPath() + "' can not be evaluated", e);
        }
    }

    protected static ICLICommandline processCommandFile(ICLICommandline candidate) {
        ICLIOption optionCf = candidate.getOption(CLIOPT_CF, CLIOPT_COMMANDFILE);
        if (optionCf == null) {
            return null;
        }
        optionCf.setProcessed(true);
        String filename = optionCf.getValue();
        File file = new File(filename);
        try {
            URI uri = new URI(filename);
            if ("file".equals(uri.getScheme())) {
                file = new File(uri);
            } else if ("csbridge".equals(uri.getScheme())) {
                try {
                    Map parameters = URLEncodingTools.decodeEntity((String)uri.getRawQuery(), (String)StandardCharsets.UTF_8.name());
                    CLICommandline commandline = new CLICommandline(null);
                    parameters.entrySet().stream().forEach(entry -> {
                        CLIOption option = new CLIOption((String)entry.getKey(), (String)entry.getKey());
                        option.addValue((String)entry.getValue());
                        commandline.addOption(option);
                    });
                    return commandline;
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("command file '" + filename + "' can not be evaluated", ex);
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return CLICommandline.parseCommandFile(file, optionCf);
    }

    public static void set(ICLICommandline commandline) {
        Active = commandline;
    }

    protected CLICommandline(String[] args) {
        this.args = args;
    }

    protected void addOption(ICLIOption option) {
        this.options.add(option);
    }

    protected void addRemainingArg(String arg) {
        this.remaining.add(arg);
    }

    @Override
    public String[] getArgs() {
        return this.args;
    }

    @Override
    public ICLIOption getOption(String name) {
        if (name == null) {
            return null;
        }
        for (ICLIOption option : this.options) {
            if (!name.equals(option.getShortName()) && !name.equals(option.getLongName())) continue;
            return option;
        }
        return null;
    }

    @Override
    public ICLIOption getOption(String shortName, String longName) {
        if (shortName == null) {
            shortName = "";
        }
        if (longName == null) {
            longName = "";
        }
        for (ICLIOption option : this.options) {
            if (!shortName.equals(option.getShortName()) && !longName.equals(option.getLongName())) continue;
            return option;
        }
        return null;
    }

    @Override
    public ICLIOption[] getOptions() {
        return (ICLIOption[])ArrayTools.toArray(ICLIOption.class, this.options);
    }

    @Override
    public ICLIOption[] getOptions(String name) {
        ArrayList<ICLIOption> result = new ArrayList<ICLIOption>();
        if (name != null) {
            for (ICLIOption option : this.options) {
                if (!name.equals(option.getShortName()) && !name.equals(option.getLongName())) continue;
                result.add(option);
            }
        }
        return result.toArray(new ICLIOption[result.size()]);
    }

    @Override
    public ICLIOption[] getOptions(String shortName, String longName) {
        if (shortName == null) {
            shortName = "";
        }
        if (longName == null) {
            longName = "";
        }
        ArrayList<ICLIOption> result = new ArrayList<ICLIOption>();
        for (ICLIOption option : this.options) {
            if (!shortName.equals(option.getShortName()) && !longName.equals(option.getLongName())) continue;
            result.add(option);
        }
        return result.toArray(new ICLIOption[result.size()]);
    }

    @Override
    public String[] getRemainingArgs() {
        return (String[])ArrayTools.toArray(String.class, this.remaining);
    }

    @Override
    public boolean isProcessed() {
        for (ICLIOption option : this.options) {
            if (option.isProcessed()) continue;
            return false;
        }
        if (this.remaining.isEmpty()) {
            return true;
        }
        return this.processed;
    }

    @Override
    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public String toString() {
        if (this.options == null || this.options.isEmpty()) {
            return "<no args>";
        }
        StringBuilder sb = new StringBuilder();
        for (ICLIOption option : this.options) {
            sb.append(option.toString());
            sb.append(" ");
        }
        return sb.toString();
    }

    static {
        Log = LoggerFactory.getLogger(CLICommandline.class);
    }
}

