/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.attribute.encoder;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.cms.SignerInfo;
import de.intarsys.asn1.common.Attribute;
import de.intarsys.security.method.cms.attribute.encoder.IAttributeEncoder;
import de.intarsys.security.method.cms.attribute.encoder.PACKAGE;
import de.intarsys.security.method.cms.signature.ICMSSignatureContainerBuilder;
import de.intarsys.security.method.cms.validation.SignerInfoValidationDataCollector;
import de.intarsys.security.signature.ValidationDataOptions;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonRevocationInfoEncoder
implements IAttributeEncoder {
    private static final Logger Log = LoggerFactory.getLogger(CommonRevocationInfoEncoder.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private ValidationDataOptions validationDataOptions = ValidationDataOptions.SIGNER;
    private boolean failOnError = false;
    private long maxSize = -1L;
    private IExtendedValidationData extendedValidationData;

    protected CommonRevocationInfoEncoder() {
    }

    protected abstract Attribute createAttribute(IExtendedValidationData var1) throws IOException;

    @Override
    public Attribute getAttribute(ICMSSignatureContainerBuilder builder, CMS cms, SignerInfo signerInfo, ISignatureData signatureData) throws IOException {
        if (this.extendedValidationData == null) {
            SignerInfoValidationDataCollector collector = new SignerInfoValidationDataCollector(signerInfo, cms);
            collector.setValidationDataOptions(this.getValidationDataOptions());
            collector.setFailOnError(this.isFailOnError());
            collector.setMaxSize(this.getMaxSize());
            this.extendedValidationData = collector.collect();
        }
        return this.createAttribute(this.extendedValidationData);
    }

    public IExtendedValidationData getExtendedValidationData() {
        return this.extendedValidationData;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public ValidationDataOptions getValidationDataOptions() {
        return this.validationDataOptions;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public void setValidationDataOptions(ValidationDataOptions validationDataOptions) {
        this.validationDataOptions = validationDataOptions;
    }
}

