/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.attribute.decoder;

import de.intarsys.asn1.cms.attr.AttributeCertificateValues;
import de.intarsys.asn1.cms.attr.CertificateValues;
import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.x509.Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.signature.attribute.IAttributeDecoder;
import de.intarsys.security.signature.attribute.ICertificateValuesAttribute;
import de.intarsys.security.signature.attribute.impl.CertificateValuesAttribute;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1Encodable;

public class CertificateValuesDecoder
implements IAttributeDecoder {
    public ICertificateValuesAttribute decodeAttribute(Object srcAttribute) throws IOException {
        CertificateValues values;
        Attribute cmsAttribute = (Attribute)srcAttribute;
        ArrayList<IX509PublicKeyCertificate> result = new ArrayList<IX509PublicKeyCertificate>();
        AttributeCertificateValues attrCerts = (AttributeCertificateValues)AttributeCertificateValues.FACTORY.create((ASN1Encodable)cmsAttribute);
        if (attrCerts != null && (values = attrCerts.getCertificateValues()) != null) {
            for (Certificate cert : values.getAll()) {
                try {
                    result.add(this.toX509Cert(cert));
                }
                catch (CertificateException e) {
                    throw new IOException(e.getLocalizedMessage(), e);
                }
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        IX509PublicKeyCertificate[] certs = result.toArray(new IX509PublicKeyCertificate[result.size()]);
        return new CertificateValuesAttribute(certs);
    }

    public String getOID() {
        return "1.2.840.113549.1.9.16.2.23";
    }

    private IX509PublicKeyCertificate toX509Cert(Certificate cert) throws IOException, CertificateException {
        return X509CertificateFactory.get().createPublicKeyCertificate(cert.getDEREncoded());
    }
}

