/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.http.httpcomponents;

import de.intarsys.aaa.authenticate.api.ICredential;
import de.intarsys.aaa.authenticate.api.ICredentialProvider;
import de.intarsys.aaa.authenticate.api.ICredentialScope;
import de.intarsys.aaa.authenticate.api.ICredentialStore;
import de.intarsys.tools.http.authenticate.HttpCredentialScope;
import de.intarsys.tools.http.httpcomponents.CredentialCredentialsProvider;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthState;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class CredentialCleanupResponseInterceptor
implements HttpResponseInterceptor {
    private static final Logger Log = LoggerFactory.getLogger(CredentialCleanupResponseInterceptor.class);

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        AuthState authState;
        AuthScheme authScheme;
        String hostAttribute;
        String stateAttribute;
        CredentialsProvider candidate = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
        if (!(candidate instanceof CredentialCredentialsProvider)) {
            return;
        }
        CredentialCredentialsProvider credentialsProvider = (CredentialCredentialsProvider)candidate;
        ICredentialProvider wrapped = credentialsProvider.getCredentialProvider();
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 401) {
            stateAttribute = "http.auth.target-scope";
            hostAttribute = "http.target_host";
        } else if (statusCode == 407) {
            stateAttribute = "http.auth.proxy-scope";
            hostAttribute = "http.proxy_host";
        } else {
            return;
        }
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("Authentication requested. stateAttr:'" + stateAttribute + "', hostAttr:'" + hostAttribute + "'");
        }
        if ((authScheme = (authState = (AuthState)context.getAttribute(stateAttribute)).getAuthScheme()) != null && authScheme.isComplete()) {
            ICredential credential;
            String host;
            HttpHost httpHost = (HttpHost)context.getAttribute(hostAttribute);
            try {
                host = InetAddress.getByName(httpHost.getHostName()).getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                host = httpHost.getHostName();
            }
            HttpCredentialScope credentialScope = new HttpCredentialScope(host, httpHost.getPort(), authScheme.getRealm(), authScheme.getSchemeName());
            if (Log.isEnabledForLevel(Level.TRACE)) {
                Log.trace("Request authentication for " + credentialScope);
            }
            if (wrapped instanceof ICredentialStore) {
                ((ICredentialStore)wrapped).removeCredential((ICredentialScope)credentialScope);
            }
            if ((credential = wrapped.getCredential((ICredentialScope)credentialScope)) != null) {
                authState.reset();
            }
        }
    }
}

