/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.http.content;

import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.http.content.IHttpEntityEncoder;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.provider.ProviderTools;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpEntityEncoder
implements IHttpEntityEncoder {
    private static final Logger Log = LoggerFactory.getLogger(HttpEntityEncoder.class);
    private static final Map<String, IHttpEntityEncoder> Registry = new HashMap<String, IHttpEntityEncoder>();

    public static IHttpEntityEncoder lookupEncoder(String type) {
        return Registry.get(type);
    }

    public static void registerEncoder(IHttpEntityEncoder encoder) {
        Log.debug("registering encoder for '" + encoder.getContentType() + "'");
        Registry.put(encoder.getContentType(), encoder);
    }

    protected HttpEntityEncoder() {
    }

    protected abstract HttpEntity basicEncode(Object var1) throws IOException;

    protected Object convert(Object value) throws IOException {
        if (value instanceof File) {
            byte[] data = FileTools.getBytes((File)((File)value));
            return new String(Base64.encode((byte[])data));
        }
        if (value instanceof FileLocator) {
            File file = ((FileLocator)value).getFile();
            byte[] data = FileTools.getBytes((File)file);
            return new String(Base64.encode((byte[])data));
        }
        if (value instanceof ILocator) {
            byte[] data = LocatorTools.getBytes((ILocator)((ILocator)value));
            return new String(Base64.encode((byte[])data));
        }
        if (value instanceof ILocatorSupport) {
            byte[] data = LocatorTools.getBytes((ILocator)((ILocatorSupport)value).getLocator());
            return new String(Base64.encode((byte[])data));
        }
        if (value instanceof byte[]) {
            return new String(Base64.encode((byte[])((byte[])value)));
        }
        if (value instanceof Throwable) {
            Throwable t = (Throwable)value;
            return ExceptionTools.toArgs((Throwable)t, (boolean)true, (boolean)false);
        }
        return value;
    }

    @Override
    public final HttpEntity encode(Object value) throws IOException {
        return this.basicEncode(value);
    }

    protected Object wrap(Object value) {
        if (value instanceof IArgs) {
            return value;
        }
        if (value instanceof Map) {
            return value;
        }
        if (value instanceof Object[]) {
            return value;
        }
        if (value instanceof Collection) {
            return value;
        }
        if (value instanceof Iterator) {
            return value;
        }
        return Args.createNamed((Object[])new Object[]{"_wrapped", value});
    }

    static {
        Iterator ps = ProviderTools.providers(IHttpEntityEncoder.class);
        while (ps.hasNext()) {
            HttpEntityEncoder.registerEncoder((IHttpEntityEncoder)ps.next());
        }
    }
}

