/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.http.content;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.http.content.HttpEntityEncoder;
import jakarta.json.Json;
import jakarta.json.stream.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;

public class HttpEntityApplicationJsonEncoder
extends HttpEntityEncoder {
    @Override
    protected HttpEntity basicEncode(Object value) throws IOException {
        value = this.wrap(value);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        JsonGenerator generator = Json.createGenerator((OutputStream)os);
        this.createEntity(generator, null, value);
        generator.close();
        return new ByteArrayEntity(os.toByteArray(), ContentType.create((String)"application/json"));
    }

    protected void createEntity(JsonGenerator generator, String name, Object value) throws IOException {
        if ((value = this.convert(value)) instanceof IArgs) {
            this.createEntityArgs(generator, name, (IArgs)value);
        } else if (value instanceof Map) {
            this.createEntityMap(generator, name, (Map)value);
        } else if (value instanceof Object[]) {
            this.createEntityArray(generator, name, (Object[])value);
        } else if (value instanceof Collection) {
            this.createEntityCollection(generator, name, (Collection)value);
        } else if (value instanceof Iterator) {
            this.createEntityIterator(generator, name, (Iterator)value);
        } else if (value instanceof Boolean) {
            this.createEntityBoolean(generator, name, (Boolean)value);
        } else if (value instanceof String) {
            this.createEntityString(generator, name, (String)value);
        } else if (value instanceof Integer) {
            this.createEntityInteger(generator, name, (Integer)value);
        } else if (value instanceof Long) {
            this.createEntityLong(generator, name, (Long)value);
        } else if (value instanceof Number) {
            this.createEntityNumber(generator, name, (Number)value);
        } else if (value == null) {
            this.createEntityNull(generator, name);
        } else {
            this.createEntityMapped(generator, name, value);
        }
    }

    protected void createEntityArgs(JsonGenerator generator, String name, IArgs args) throws IOException {
        boolean named = args.isNamed();
        if (named) {
            if (name == null) {
                generator.writeStartObject();
            } else {
                generator.writeStartObject(name);
            }
        } else if (name == null) {
            generator.writeStartArray();
        } else {
            generator.writeStartArray(name);
        }
        int i = 0;
        Iterator it = args.bindings();
        while (it.hasNext()) {
            IArgs.IBinding binding = (IArgs.IBinding)it.next();
            Object childName = binding.getName();
            if (named && childName == null) {
                childName = "" + i;
            }
            ++i;
            Object value = binding.getValue();
            this.createEntity(generator, (String)childName, value);
        }
        generator.writeEnd();
    }

    protected void createEntityArray(JsonGenerator generator, String name, Object[] array) throws IOException {
        if (name == null) {
            generator.writeStartArray();
        } else {
            generator.writeStartArray(name);
        }
        for (int i = 0; i < array.length; ++i) {
            Object value = array[i];
            this.createEntity(generator, null, value);
        }
        generator.writeEnd();
    }

    protected void createEntityBoolean(JsonGenerator generator, String name, boolean value) throws IOException {
        if (name == null) {
            generator.write(value);
        } else {
            generator.write(name, value);
        }
    }

    protected void createEntityCollection(JsonGenerator generator, String name, Collection collection) throws IOException {
        if (name == null) {
            generator.writeStartArray();
        } else {
            generator.writeStartArray(name);
        }
        for (Object value : collection) {
            this.createEntity(generator, null, value);
        }
        generator.writeEnd();
    }

    protected void createEntityInteger(JsonGenerator generator, String name, int value) throws IOException {
        if (name == null) {
            generator.write(value);
        } else {
            generator.write(name, value);
        }
    }

    protected void createEntityIterator(JsonGenerator generator, String name, Iterator it) throws IOException {
        if (name == null) {
            generator.writeStartArray();
        } else {
            generator.writeStartArray(name);
        }
        while (it.hasNext()) {
            Object value = it.next();
            this.createEntity(generator, null, value);
        }
        generator.writeEnd();
    }

    protected void createEntityLong(JsonGenerator generator, String name, long value) throws IOException {
        if (name == null) {
            generator.write(value);
        } else {
            generator.write(name, value);
        }
    }

    protected void createEntityMap(JsonGenerator generator, String name, Map map) throws IOException {
        if (name == null) {
            generator.writeStartObject();
        } else {
            generator.writeStartObject(name);
        }
        for (Map.Entry entry : map.entrySet()) {
            String childName = String.valueOf(entry.getKey());
            Object value = entry.getValue();
            this.createEntity(generator, childName, value);
        }
        generator.writeEnd();
    }

    protected void createEntityMapped(JsonGenerator generator, String name, Object value) throws IOException {
        String string;
        try {
            string = (String)ConverterRegistry.get().convert(value, String.class);
        }
        catch (ConversionException e) {
            throw new IOException(e);
        }
        this.createEntityString(generator, name, string);
    }

    protected void createEntityNull(JsonGenerator generator, String name) throws IOException {
        if (name == null) {
            generator.writeNull();
        } else {
            generator.writeNull(name);
        }
    }

    protected void createEntityNumber(JsonGenerator generator, String name, Number value) throws IOException {
        if (name == null) {
            generator.write(value.doubleValue());
        } else {
            generator.write(name, value.doubleValue());
        }
    }

    protected void createEntityString(JsonGenerator generator, String name, String value) throws IOException {
        if (name == null) {
            generator.write(value);
        } else {
            generator.write(name, value);
        }
    }

    @Override
    public String getContentType() {
        return "application/json";
    }
}

