/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.preferences.claptz;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.impl.ExtensionPointHandlerAdapter;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.PreferencesFactory;
import de.intarsys.tools.preferences.PreferencesTools;

public class PreferencesDefaultsInstaller
extends ExtensionPointHandlerAdapter {
    public static final String XP_DECLARATION = "de.intarsys.preferences.defaults";
    public static final String XE_NODE = "node";
    public static final String XE_MAIN = "main";
    public static final String XE_ROOT = "root";

    @Override
    protected Object basicInstallInsert(IExtension extension, IElement element) {
        if (XE_NODE.equals(element.getName())) {
            String pathName = element.attributeValue("name", null);
            IPreferences root = PreferencesFactory.get().getRoot();
            IPreferences preferences = root.node(pathName);
            if (preferences == null) {
                return null;
            }
            this.setPreferences(preferences, element);
        } else if (XE_MAIN.equals(element.getName())) {
            IPreferences preferences = PreferencesFactory.get().getMain();
            this.setPreferences(preferences, element);
        } else if (XE_ROOT.equals(element.getName())) {
            IPreferences preferences = PreferencesFactory.get().getRoot();
            this.setPreferences(preferences, element);
        } else {
            return super.basicInstallInsert(extension, element);
        }
        return null;
    }

    protected void setPreferences(IPreferences preferences, IElement element) {
        PreferencesTools.setPreferences((IPreferences)preferences.restrict("DEFAULT"), (IElement)element);
    }
}

