/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.impl;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.IExtensionPoint;
import de.intarsys.claptz.IExtensionPointHandler;
import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.impl.ExtensionOperation;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.exception.InitializationException;
import de.intarsys.tools.format.Format;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reporter.Reporter;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class ExtensionPointHandlerAdapter
implements IExtensionPointHandler {
    private static final String TITLE_ERROR = "Error";
    private static final String ARG_ELEMENT = "element";
    private static final String ARG_EXTENSION = "extension";
    private static final String ARG_INSTALLER = "installer";
    private static final String ATTR_ONERROR = "onerror";
    private static final Logger Log = LoggerFactory.getLogger(ExtensionPointHandlerAdapter.class);
    private static final String VALUE_IGNORE = "ignore";
    private final Attribute attrInstalled = new Attribute("installed");
    private IExtensionPoint extensionPoint;
    private boolean installed;

    protected List<ExtensionOperation> basicGetAttachments(IExtension extension) {
        return extension.getOperations();
    }

    protected void basicInstall() throws InstrumentRegistryException {
        List<IExtension> extensions = this.extensionPoint.getExtensions();
        for (IExtension extension : extensions) {
            try {
                this.install(extension);
            }
            catch (Throwable t) {
                Reporter.get().reportError(TITLE_ERROR, StringTools.safeString((Object)extension) + " unexpected installation error", t, 0);
            }
        }
    }

    protected void basicInstall(IExtension extension) {
        IElement root = extension.getElement();
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            IElement childElement = (IElement)it.next();
            String op = childElement.attributeValue("_op", null);
            String onError = childElement.attributeValue(ATTR_ONERROR, null);
            try {
                Object object;
                if (op == null || "insert".equals(op)) {
                    object = this.basicInstallInsert(extension, childElement);
                    if (object == null) continue;
                    extension.attachInsert(object);
                    continue;
                }
                if ("update".equals(op)) {
                    object = this.basicInstallUpdate(extension, childElement);
                    if (object == null) continue;
                    extension.attachUpdate(object);
                    continue;
                }
                if ("delete".equals(op)) {
                    object = this.basicInstallDelete(extension, childElement);
                    if (object == null) continue;
                    extension.attachDelete(object);
                    continue;
                }
                String msg = Format.printf((String)"%s  element %s unsupported operation %s", (Object[])new Object[]{StringTools.safeString((Object)extension), childElement.getName(), op});
                Reporter.get().reportError(TITLE_ERROR, msg, null, 0);
            }
            catch (Throwable t) {
                String msg;
                if (VALUE_IGNORE.equals(onError)) {
                    msg = this.createMessage(extension, childElement, "bean creation failure, ignore (" + ExceptionTools.getMessage((Throwable)t) + ")");
                    Log.info(msg);
                    continue;
                }
                msg = this.createMessage(extension, childElement, "bean creation failure");
                Log.warn(msg);
                throw new InitializationException(msg, t);
            }
        }
    }

    protected Object basicInstallDelete(IExtension extension, IElement element) {
        Log.warn(StringTools.safeString((Object)extension) + " delete not supported for element '" + element.getName() + "'");
        return null;
    }

    protected Object basicInstallInsert(IExtension extension, IElement element) {
        Log.warn(StringTools.safeString((Object)extension) + " unknown element '" + element.getName() + "'");
        return null;
    }

    protected Object basicInstallUpdate(IExtension extension, IElement element) {
        Log.warn(StringTools.safeString((Object)extension) + " update not supported for element '" + element.getName() + "'");
        return null;
    }

    protected void basicUninstall() {
        List<IExtension> extensions = this.getExtensionPoint().getExtensions();
        for (IExtension extension : extensions) {
            try {
                this.uninstall(extension);
            }
            catch (Throwable t) {
                Reporter.get().reportError(TITLE_ERROR, StringTools.safeString((Object)extension) + " unexpected uninstall error", t, 0);
            }
        }
    }

    protected void basicUninstall(IExtension extension) {
        IElement root = extension.getElement();
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            IElement childElement = (IElement)it.next();
            try {
                this.basicUninstall(extension, childElement);
            }
            catch (Throwable t) {
                Reporter.get().reportError(TITLE_ERROR, StringTools.safeString((Object)extension) + " element " + childElement.getName() + " unexpected uninstallation error", t, 0);
            }
        }
    }

    protected void basicUninstall(IExtension extension, IElement element) {
    }

    protected String createMessage(IExtension extension, IElement element, String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringTools.safeString((Object)extension));
        if (element != null) {
            sb.append(" element '");
            sb.append(element.getName());
        }
        sb.append("': ");
        sb.append(msg);
        String string = sb.toString();
        return string;
    }

    @Override
    public IExtensionPoint getExtensionPoint() {
        return this.extensionPoint;
    }

    protected List<Object> getManagedObjects(IExtension extension) {
        return new ArrayList<Object>();
    }

    protected void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void install() throws InstrumentRegistryException {
        ExtensionPointHandlerAdapter extensionPointHandlerAdapter = this;
        synchronized (extensionPointHandlerAdapter) {
            if (this.isInstalled()) {
                return;
            }
            this.setInstalled(true);
            this.basicInstall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void install(IExtension extension) throws InstrumentRegistryException {
        ExtensionPointHandlerAdapter extensionPointHandlerAdapter = this;
        synchronized (extensionPointHandlerAdapter) {
            if (extension.getAttribute(this.attrInstalled) != null) {
                return;
            }
            extension.setAttribute(this.attrInstalled, Boolean.TRUE);
            this.basicInstall(extension);
        }
    }

    @Override
    public boolean isDeferred() {
        return false;
    }

    @Override
    public boolean isInstalled() {
        return this.installed;
    }

    protected void log(Logger log, Level level, IExtension extension, IElement element, String msg, Throwable e) {
        String string = this.createMessage(extension, element, msg);
        log.atLevel(level).log(string, (Object)e);
    }

    protected void log(Logger log, Level level, IExtension extension, String msg, Throwable e) {
        String string = this.createMessage(extension, null, msg);
        log.atLevel(level).log(string, (Object)e);
    }

    protected Object performFunctor(IExtension extension, IElement element) throws ObjectCreationException, FunctorException {
        IFunctor functor = ElementTools.createFunctor((Object)extension.getProvider(), (IElement)element, null, (Object)extension.getProvider());
        Args args = Args.create();
        args.put(ARG_INSTALLER, (Object)this);
        args.put(ARG_EXTENSION, (Object)this);
        args.put(ARG_ELEMENT, (Object)this);
        FunctorCall call = new FunctorCall((Object)extension, (IArgs)args);
        return functor.perform((IFunctorCall)call);
    }

    protected Object performNestedFunctor(IExtension extension, IElement element, String functorElementName) throws ObjectCreationException, FunctorException {
        IFunctor functor = ElementTools.createFunctor((Object)extension.getProvider(), (IElement)element.element(functorElementName), null, (Object)extension.getProvider());
        Args args = Args.create();
        args.put(ARG_INSTALLER, (Object)this);
        args.put(ARG_EXTENSION, (Object)this);
        args.put(ARG_ELEMENT, (Object)this);
        FunctorCall call = new FunctorCall((Object)extension, (IArgs)args);
        return functor.perform((IFunctorCall)call);
    }

    @Override
    public final void setExtensionPoint(IExtensionPoint extensionPoint) {
        this.extensionPoint = extensionPoint;
        this.initialize();
    }

    protected void setInstalled(boolean installed) {
        this.installed = installed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void uninstall() throws InstrumentRegistryException {
        ExtensionPointHandlerAdapter extensionPointHandlerAdapter = this;
        synchronized (extensionPointHandlerAdapter) {
            if (this.getExtensionPoint() == null || !this.isInstalled()) {
                return;
            }
            this.setInstalled(false);
            this.basicUninstall();
            this.extensionPoint = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void uninstall(IExtension extension) throws InstrumentRegistryException {
        ExtensionPointHandlerAdapter extensionPointHandlerAdapter = this;
        synchronized (extensionPointHandlerAdapter) {
            if (extension.getAttribute(this.attrInstalled) == null) {
                return;
            }
            extension.setAttribute(this.attrInstalled, null);
            this.basicUninstall(extension);
        }
    }

    @Override
    public void update(IExtension extension) throws InstrumentRegistryException {
        List<ExtensionOperation> attachments = this.basicGetAttachments(extension);
        extension.getElement().elementsClear();
        for (ExtensionOperation attachment : attachments) {
            try {
                attachment.perform(extension);
            }
            catch (Exception e) {
                this.log(Log, Level.WARN, extension, e.getLocalizedMessage(), e);
            }
        }
    }
}

