/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.container;

import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.container.InstrumentProvider;
import de.intarsys.claptz.impl.StandardInstrumentRegistry;
import de.intarsys.claptz.io.DirectoryInstrumentStore;
import de.intarsys.tools.cli.CLICommandline;
import de.intarsys.tools.cli.ICLICommandline;
import de.intarsys.tools.cli.ICLIOption;
import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.file.FileLoader;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.file.IPathFilter;
import de.intarsys.tools.file.PathFilter;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.system.SystemTools;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentDirectoryProvider
extends InstrumentProvider {
    private static final String ARG_IT_DIRS = "itDirs";
    private static final String ARG_IT_STRICT = "itStrict";
    private static final Logger Log = LoggerFactory.getLogger(InstrumentDirectoryProvider.class);
    private static final String DIR_INSTRUMENTS = "instruments";
    protected static final String CONFIG_INSTRUMENTS = "instruments";
    protected static final String CONFIG_PATH = "path";
    protected static final String CONFIG_LOAD = "load";
    protected static final String CONFIG_INCLUDE = "include";
    private static final String ATTR_NAME = "name";
    protected static final String CONFIG_EXCLUDE = "exclude";
    public static final String CLIOPT_ITDIRS = "itdirs";
    public static final String CLIOPT_ITSTRICT = "itstrict";
    private static final String SEPARATOR = ";";
    private List<String> instrumentDirs = new ArrayList<String>();
    private boolean instrumentDirsStrict;
    private IElement configuration;

    @Override
    public void configureCLI(ICLICommandline icliCommandline) {
        ICLIOption optItdirs;
        super.configureCLI(icliCommandline);
        ICLIOption optIstrict = CLICommandline.get().getOption(CLIOPT_ITSTRICT);
        if (optIstrict != null) {
            optIstrict.setProcessed(true);
            this.setInstrumentDirsStrict(true);
        }
        if ((optItdirs = CLICommandline.get().getOption(CLIOPT_ITDIRS)) != null) {
            optItdirs.setProcessed(true);
            StringTokenizer st = new StringTokenizer(optItdirs.getValue(), SEPARATOR);
            while (st.hasMoreTokens()) {
                String path = st.nextToken().trim();
                if (StringTools.isEmpty((String)path)) continue;
                this.getInstrumentDirs().add(path);
            }
        }
    }

    @Override
    public void configureElement(IElement configuration) {
        super.configureElement(configuration);
        this.setConfiguration(configuration);
    }

    public IElement getConfiguration() {
        return this.configuration;
    }

    public List<String> getInstrumentDirs() {
        return this.instrumentDirs;
    }

    public boolean isInstrumentDirsStrict() {
        return this.instrumentDirsStrict;
    }

    @Override
    public void load(StandardInstrumentRegistry instrumentRegistry) throws InstrumentRegistryException {
        IElement instrumentsElement;
        boolean loadStrict = this.isInstrumentDirsStrict();
        List<String> itDirs = this.getInstrumentDirs();
        boolean instrumentsDirByDefault = false;
        if (!loadStrict && !itDirs.contains("instruments")) {
            itDirs.add("instruments");
            instrumentsDirByDefault = true;
        }
        if (loadStrict && itDirs.isEmpty()) {
            itDirs.add("instruments");
            instrumentsDirByDefault = true;
        }
        if ((instrumentsElement = this.getConfiguration().element("instruments")) != null) {
            Iterator loadElements = instrumentsElement.elementIterator(CONFIG_LOAD);
            while (loadElements.hasNext()) {
                IElement loadElement = (IElement)loadElements.next();
                String path = loadElement.attributeValue(CONFIG_PATH, null);
                if (StringTools.isEmpty((String)path)) continue;
                itDirs.remove(path);
                if (instrumentsDirByDefault) {
                    itDirs.remove("instruments");
                }
                IPathFilter filter = this.parsePathFilter(loadElement);
                try {
                    InstrumentLoader loader = new InstrumentLoader(instrumentRegistry);
                    loader.load(FileEnvironment.get().getBaseDir(), path, false, false, filter);
                }
                catch (IOException e) {
                    if (e.getCause() instanceof InstrumentRegistryException) {
                        throw (InstrumentRegistryException)e.getCause();
                    }
                    throw new InstrumentRegistryException("error loading instruments in '" + path + "'", e);
                }
            }
        }
        if (SystemTools.isDebug((String)"claptz.instrument.dynamic")) {
            HashSet<String> tempDirs = new HashSet<String>();
            for (String dir : itDirs) {
                File file = FileTools.resolvePath((File)FileEnvironment.get().getBaseDir(), (String)dir);
                try {
                    tempDirs.add(file.getCanonicalPath());
                }
                catch (IOException e) {
                    Log.info("dynamic instrument {} not resolvable", (Object)file);
                }
            }
            ClassLoader classloader = this.getClass().getClassLoader();
            if (classloader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)classloader).getURLs();
                File workspaceDir = FileEnvironment.get().getBaseDir().getParentFile();
                File[] projectDirs = workspaceDir.listFiles();
                if (projectDirs != null) {
                    for (File projectDir : projectDirs) {
                        File file;
                        boolean load = false;
                        for (URL url : urls) {
                            File urlDir = new File(url.getFile());
                            if (!urlDir.getAbsolutePath().startsWith(projectDir.getAbsolutePath())) continue;
                            load = true;
                            break;
                        }
                        if (!load || !(file = new File(projectDir, "instruments")).exists()) continue;
                        try {
                            tempDirs.add(file.getCanonicalPath());
                        }
                        catch (IOException e) {
                            Log.info("dynamic instrument {} not resolvable", (Object)file);
                        }
                    }
                }
            }
            itDirs = new ArrayList<String>(tempDirs);
        }
        for (String path : itDirs) {
            File file = FileTools.resolvePath((File)FileEnvironment.get().getBaseDir(), (String)path);
            if (file.exists()) {
                DirectoryInstrumentStore store = new DirectoryInstrumentStore(file);
                instrumentRegistry.load(store);
                continue;
            }
            Log.info("instrument path '" + file + "' does not exist");
        }
    }

    protected IPathFilter parsePathFilter(IElement loadElement) {
        String name;
        PathFilter fileSet = new PathFilter();
        Iterator i = loadElement.elementIterator(CONFIG_INCLUDE);
        while (i.hasNext()) {
            IElement include = (IElement)i.next();
            name = include.attributeValue(ATTR_NAME, null);
            if (StringTools.isEmpty((String)name)) continue;
            fileSet.addInclude(name);
        }
        i = loadElement.elementIterator(CONFIG_EXCLUDE);
        while (i.hasNext()) {
            IElement exclude = (IElement)i.next();
            name = exclude.attributeValue(ATTR_NAME, null);
            if (StringTools.isEmpty((String)name)) continue;
            fileSet.addExclude(name);
        }
        return fileSet;
    }

    public void setConfiguration(IElement configuration) {
        this.configuration = configuration;
    }

    public void setInstrumentDirs(List<String> instrumentDirs) {
        this.instrumentDirs = instrumentDirs;
    }

    public void setInstrumentDirsStrict(boolean instrumentDirsStrict) {
        this.instrumentDirsStrict = instrumentDirsStrict;
    }

    public static class InstrumentLoader
    extends FileLoader {
        private final StandardInstrumentRegistry instrumentRegistry;

        public InstrumentLoader(StandardInstrumentRegistry instrumentRegistry) {
            this.instrumentRegistry = instrumentRegistry;
        }

        protected boolean basicLoadDirectory(File file, boolean readOnly, boolean recursive, String path, IPathFilter filter) throws IOException {
            try {
                DirectoryInstrumentStore store = new DirectoryInstrumentStore(file, filter);
                this.instrumentRegistry.load(store);
                return true;
            }
            catch (InstrumentRegistryException e) {
                throw new IOException(e);
            }
        }

        protected boolean basicLoadFile(File file, boolean readOnly, String path) throws IOException {
            return false;
        }
    }
}

