/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.IExtensionPoint;
import de.intarsys.claptz.IExtensionPointHandler;
import de.intarsys.claptz.InstrumentRegistry;
import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.reporter.Reporter;
import de.intarsys.tools.string.StringTools;
import java.util.List;

public class ExtensionPointDelegator
implements IExtensionPointHandler,
IElementConfigurable {
    private static final String TITLE_ERROR = "Error";
    private String delegateId;
    private IExtensionPoint delegate;
    private IExtensionPointHandler delegateHandler;
    private final Attribute attrInstalled = new Attribute("installed");
    private IExtensionPoint extensionPoint;
    private boolean installed;

    protected void basicInstall() throws InstrumentRegistryException {
        List<IExtension> extensions = this.extensionPoint.getExtensions();
        for (IExtension extension : extensions) {
            try {
                this.install(extension);
            }
            catch (Throwable t) {
                Reporter.get().reportError(TITLE_ERROR, StringTools.safeString((Object)extension) + " unexpected installation error", t, 0);
            }
        }
    }

    protected void basicInstall(IExtension extension) throws InstrumentRegistryException {
        this.getDelegateHandler().install(extension);
    }

    protected void basicUninstall() {
        List<IExtension> extensions = this.getExtensionPoint().getExtensions();
        for (IExtension extension : extensions) {
            try {
                this.uninstall(extension);
            }
            catch (Throwable t) {
                Reporter.get().reportError(TITLE_ERROR, StringTools.safeString((Object)extension) + " unexpected uninstall error", t, 0);
            }
        }
    }

    protected void basicUninstall(IExtension extension) throws InstrumentRegistryException {
        this.getDelegateHandler().uninstall(extension);
    }

    public void configure(IElement element) throws ConfigurationException {
        this.setDelegateId(element.attributeValue("delegateId", null));
    }

    public IExtensionPoint getDelegate() {
        if (this.delegate == null) {
            this.delegate = InstrumentRegistry.get().lookupExtensionPoint(this.getDelegateId());
        }
        return this.delegate;
    }

    protected IExtensionPointHandler getDelegateHandler() {
        if (this.delegateHandler == null) {
            this.delegateHandler = this.getDelegate().getInstaller();
        }
        return this.delegateHandler;
    }

    public String getDelegateId() {
        return this.delegateId;
    }

    @Override
    public IExtensionPoint getExtensionPoint() {
        return this.extensionPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void install() throws InstrumentRegistryException {
        ExtensionPointDelegator extensionPointDelegator = this;
        synchronized (extensionPointDelegator) {
            if (this.isInstalled()) {
                return;
            }
            this.setInstalled(true);
            this.basicInstall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void install(IExtension extension) throws InstrumentRegistryException {
        ExtensionPointDelegator extensionPointDelegator = this;
        synchronized (extensionPointDelegator) {
            if (extension.getAttribute(this.attrInstalled) != null) {
                return;
            }
            extension.setAttribute(this.attrInstalled, Boolean.TRUE);
            this.basicInstall(extension);
        }
    }

    @Override
    public boolean isDeferred() {
        return false;
    }

    @Override
    public boolean isInstalled() {
        return this.installed;
    }

    public void setDelegate(IExtensionPoint delegate) {
        this.delegate = delegate;
    }

    public void setDelegateId(String delegateId) {
        this.delegateId = delegateId;
    }

    @Override
    public final void setExtensionPoint(IExtensionPoint extensionPoint) {
        this.extensionPoint = extensionPoint;
    }

    protected void setInstalled(boolean installed) {
        this.installed = installed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void uninstall() throws InstrumentRegistryException {
        ExtensionPointDelegator extensionPointDelegator = this;
        synchronized (extensionPointDelegator) {
            if (this.getExtensionPoint() == null || !this.isInstalled()) {
                return;
            }
            this.setInstalled(false);
            this.basicUninstall();
            this.extensionPoint = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void uninstall(IExtension extension) throws InstrumentRegistryException {
        ExtensionPointDelegator extensionPointDelegator = this;
        synchronized (extensionPointDelegator) {
            if (extension.getAttribute(this.attrInstalled) == null) {
                return;
            }
            extension.setAttribute(this.attrInstalled, null);
            this.basicUninstall(extension);
        }
    }

    @Override
    public void update(IExtension extension) throws InstrumentRegistryException {
        this.getDelegateHandler().update(extension);
    }
}

