/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.loadbalance;

import de.intarsys.tools.jaxrs.JaxrsTools;
import de.intarsys.tools.loadbalance.ILoadBalanceContext;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.UriBuilder;
import java.util.UUID;

public class StandardLoadBalanceContext
implements ILoadBalanceContext {
    public static final String DEFAULT_STICKY_ID = "sticky_id";
    private boolean strict = true;
    private String cookieValue;
    private String cookieName = "sticky_id";
    private String cookieDomain = null;
    private String cookiePath = "/";
    private boolean cookieHttpOnly = false;
    private boolean cookieSecure = false;
    private int cookieMaxAge = -1;

    protected String createCookieDomain() {
        if ("_dynamic".equals(this.getCookieDomain())) {
            UriBuilder builder = JaxrsTools.getUriBuilderRoot();
            return builder.build(new Object[0]).getHost();
        }
        if (StringTools.isEmpty((String)this.getCookieDomain()) || "_none".equals(this.getCookieDomain())) {
            return null;
        }
        return this.getCookieDomain();
    }

    protected boolean createCookieHttpOnly() {
        return this.cookieHttpOnly;
    }

    protected int createCookieMaxAge() {
        return this.cookieMaxAge;
    }

    protected String createCookieName() {
        return this.cookieName;
    }

    protected String createCookiePath() {
        if ("_dynamic".equals(this.getCookiePath())) {
            UriBuilder builder = JaxrsTools.getUriBuilderContext();
            return builder.build(new Object[0]).getPath();
        }
        if (StringTools.isEmpty((String)this.getCookiePath()) || "_none".equals(this.getCookiePath())) {
            return null;
        }
        return this.getCookiePath();
    }

    protected boolean createCookieSecure() {
        return this.cookieSecure;
    }

    protected String createCookieValue() {
        return this.getCookieValue();
    }

    protected int createCookieVersion() {
        return 1;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public int getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public String getCookieValue() {
        return this.cookieValue;
    }

    @PostConstruct
    public void init() {
        if (StringTools.isEmpty((String)this.getCookieName())) {
            throw new IllegalStateException("cookieName required");
        }
        if (StringTools.isEmpty((String)this.getCookieValue())) {
            this.cookieValue = UUID.randomUUID().toString();
        }
    }

    public boolean isCookieHttpOnly() {
        return this.cookieHttpOnly;
    }

    public boolean isCookieSecure() {
        return this.cookieSecure;
    }

    public boolean isStrict() {
        return this.strict;
    }

    @Override
    public void processResponse(HttpServletResponse response) {
        String newCookieName = this.createCookieName();
        String newCookieValue = this.createCookieValue();
        String newCookiePath = this.createCookiePath();
        String newCookieDomain = this.createCookieDomain();
        int newCookieVersion = this.createCookieVersion();
        int newCookieMaxAge = this.createCookieMaxAge();
        boolean newCookieSecure = this.createCookieSecure();
        boolean newCookieHttpOnly = this.createCookieHttpOnly();
        Cookie cookie = new Cookie(newCookieName, newCookieValue);
        if (newCookiePath != null) {
            cookie.setPath(newCookiePath);
        }
        if (newCookieDomain != null) {
            cookie.setDomain(newCookieDomain);
        }
        cookie.setMaxAge(newCookieMaxAge);
        cookie.setSecure(newCookieSecure);
        cookie.setHttpOnly(newCookieHttpOnly);
        response.addCookie(cookie);
    }

    @Override
    public void processUri(UriBuilder builder) {
        String newCookieName = this.createCookieName();
        String newCookieValue = this.createCookieValue();
        builder.replaceQueryParam(newCookieName, new Object[]{newCookieValue});
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public void setCookieHttpOnly(boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
    }

    public void setCookieMaxAge(int cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public void setCookieSecure(boolean cookieSecure) {
        this.cookieSecure = cookieSecure;
    }

    public void setCookieValue(String machineIdentifier) {
        this.cookieValue = machineIdentifier;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    @Override
    public void verify(ContainerRequestContext requestContext) {
        if (!this.isStrict()) {
            return;
        }
        String value = (String)requestContext.getUriInfo().getQueryParameters().getFirst((Object)this.getCookieName());
        if (value != null) {
            if (value.equals(this.getCookieValue())) {
                return;
            }
            throw new IllegalArgumentException(requestContext.getUriInfo().getRequestUri() + " query param '" + this.getCookieName() + "' expected '" + this.getCookieValue() + "', but was '" + value + "'");
        }
        if (requestContext.getCookies() != null) {
            for (jakarta.ws.rs.core.Cookie cookie : requestContext.getCookies().values()) {
                if (!cookie.getName().equals(this.getCookieName())) continue;
                if (cookie.getValue().equals(this.getCookieValue())) {
                    return;
                }
                throw new IllegalArgumentException(requestContext.getUriInfo().getRequestUri() + " cookie '" + cookie.getName() + "' expected '" + this.getCookieValue() + "', but was '" + cookie.getValue() + "'");
            }
        }
        throw new IllegalArgumentException(requestContext.getUriInfo().getRequestUri() + " query param or cookie '" + this.getCookieName() + "' expected '" + this.getCookieValue() + "', but was '" + value + "'");
    }
}

