/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.jaxrs;

import de.intarsys.tools.collection.ListTools;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpServletRequestWithForm
extends HttpServletRequestWrapper {
    private final MultivaluedMap<String, String> form;
    private final boolean hideQuery;

    public HttpServletRequestWithForm(HttpServletRequest request, MultivaluedMap<String, String> form) {
        this(request, form, true);
    }

    public HttpServletRequestWithForm(HttpServletRequest request, MultivaluedMap<String, String> form, boolean hideQuery) {
        super(request);
        this.form = form;
        this.hideQuery = hideQuery;
    }

    public String getParameter(String name) {
        String result = (String)this.form.getFirst((Object)name);
        if (!this.isHideQuery() && result == null) {
            return super.getParameter(name);
        }
        return result;
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> params = this.isHideQuery() ? new HashMap<String, String[]>() : new HashMap(super.getParameterMap());
        this.form.entrySet().stream().forEach(entry -> params.put((String)entry.getKey(), this.toArray((List)entry.getValue())));
        return params;
    }

    public Enumeration<String> getParameterNames() {
        List params = this.isHideQuery() ? new ArrayList() : ListTools.toList((Enumeration)super.getParameterNames());
        params.addAll(this.form.keySet());
        return Collections.enumeration(params);
    }

    public String[] getParameterValues(String name) {
        List result = (List)this.form.getOrDefault((Object)name, null);
        if (!this.isHideQuery() && result == null) {
            return super.getParameterValues(name);
        }
        return result == null ? new String[]{} : this.toArray(result);
    }

    public boolean isHideQuery() {
        return this.hideQuery;
    }

    protected String[] toArray(List<String> values) {
        return values.toArray(new String[values.size()]);
    }
}

