/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.x509;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ScalarHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.tools.string.PrettyPrinter;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;

public class CertificateSerialNumber
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public static CertificateSerialNumber create(BigInteger value) {
        return (CertificateSerialNumber)FACTORY.create((ASN1Encodable)new ASN1Integer(value));
    }

    public BigInteger getValue() {
        return this.getValueHolder().toDERInteger().getValue();
    }

    public void setValue(BigInteger serialNumber) {
        this.getValueHolder().setValue((ASN1Primitive)new ASN1Integer(serialNumber));
    }

    @Override
    public void toString(PrettyPrinter printer) {
        printer.appendValue((Object)this.getValue().toString());
    }

    public static class Factory
    extends ASN1Based.Factory<CertificateSerialNumber> {
        @Override
        protected ASN1ValueHolder basicCreateValueHolder() {
            return new ASN1ScalarHolder();
        }
    }
}

