/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.rfc3161;

import de.intarsys.asn1.common.GeneralName;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.rfc3161.MessageImprint;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.tsp.Accuracy;

public class TSTInfo
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public ASN1GeneralizedTime getGenTime() {
        ASN1ValueHolder value = this.getValueHolder().getChild(4);
        return ASN1GeneralizedTime.getInstance((Object)value.getValue());
    }

    public MessageImprint getMessageImprint() {
        ASN1ValueHolder value = this.getValueHolder().getChild(2);
        return (MessageImprint)MessageImprint.FACTORY.create(value);
    }

    public BigInteger getNonce() {
        ASN1ValueHolder value = this.getValueHolder().getNextTyped(5, ASN1Integer.class);
        if (value == null) {
            return null;
        }
        return value.toDERInteger().getValue();
    }

    public BigInteger getSerialNumber() {
        return this.getValueHolder().getChild(3).toDERInteger().getValue();
    }

    public GeneralName getTsa() {
        ASN1ValueHolder value = this.getValueHolder().getNextTaggedGetChild(5, 0, true);
        if (value == null) {
            return null;
        }
        return (GeneralName)GeneralName.FACTORY.create(value);
    }

    public String getTSAPolicyId() {
        return this.getValueHolder().getChild(1).toDERObjectIdentifier().getId();
    }

    public int getVersion() {
        return this.getValueHolder().getChild(0).toDERInteger().getValue().intValue();
    }

    private boolean isAccuracyExistent() {
        ASN1ValueHolder o = this.getValueHolder().getNextTyped(5, ASN1Sequence.class);
        return o != null;
    }

    private boolean isNonceExistent() {
        ASN1ValueHolder o = this.getValueHolder().getNextTyped(5, ASN1Integer.class);
        return o != null;
    }

    private boolean isOrderingExistent() {
        ASN1ValueHolder o = this.getValueHolder().getNextTyped(5, ASN1Boolean.class);
        return o != null;
    }

    private boolean isTsaExistent() {
        ASN1TaggedHolder o = this.getValueHolder().getNextTagged(5, 0);
        return o != null;
    }

    public void setAccuracy(Accuracy accuracy) {
        int index = 5;
        if (this.isAccuracyExistent()) {
            this.getValueHolder().setChild(index, (ASN1Encodable)accuracy);
        } else {
            this.getValueHolder().insertChild(index, (ASN1Encodable)accuracy);
        }
    }

    public void setGenTime(ASN1GeneralizedTime time) {
        this.getValueHolder().setChild(4, (ASN1Encodable)time);
    }

    public void setMessageImprint(MessageImprint messageImprint) {
        this.getValueHolder().setChild(2, messageImprint);
    }

    public void setNonce(BigInteger nonce) {
        int index = 5;
        if (this.isAccuracyExistent()) {
            ++index;
        }
        if (this.isOrderingExistent()) {
            ++index;
        }
        if (this.isNonceExistent()) {
            this.getValueHolder().setChild(index, (ASN1Encodable)new ASN1Integer(nonce));
        } else {
            this.getValueHolder().insertChild(index, (ASN1Encodable)new ASN1Integer(nonce));
        }
    }

    public void setSerialNumber(BigInteger serialNumber) {
        this.getValueHolder().setChild(3, (ASN1Encodable)new ASN1Integer(serialNumber));
    }

    public void setTsa(GeneralName tsa) {
        int index = 5;
        if (this.isAccuracyExistent()) {
            ++index;
        }
        if (this.isOrderingExistent()) {
            ++index;
        }
        if (this.isNonceExistent()) {
            ++index;
        }
        ASN1TaggedHolder tagged = new ASN1TaggedHolder(true, 0, tsa);
        if (this.isTsaExistent()) {
            this.getValueHolder().setChild(index, tagged);
        } else {
            this.getValueHolder().insertChild(index, tagged);
        }
    }

    public void setTSAPolicyId(String algorithmIdentifier) {
        this.getValueHolder().setChild(1, (ASN1Encodable)new ASN1ObjectIdentifier(algorithmIdentifier));
    }

    public void setVersion(int version) {
        this.getValueHolder().setChild(0, (ASN1Encodable)new ASN1Integer((long)version));
    }

    public static class Factory
    extends ASN1Based.Factory<TSTInfo> {
    }
}

