/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.policy;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.policy.CertInfoReq;
import de.intarsys.asn1.policy.CertRefReq;
import de.intarsys.asn1.policy.SignPolExtensions;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Boolean;

public class SignerRules
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    protected static List<String> toOidList(ASN1ValueHolder asn1SequenceHolder) {
        ArrayList<String> oids = new ArrayList<String>();
        for (int i = 0; i < asn1SequenceHolder.size(); ++i) {
            oids.add(asn1SequenceHolder.getChild(i).toDERObjectIdentifier().getId());
        }
        return oids;
    }

    public Boolean getExternalSignedData() {
        if (!this.isExternalSignedDataPresent()) {
            return null;
        }
        ASN1ValueHolder externalSignedData = this.getValueHolder().getChild(0);
        if (externalSignedData == null) {
            return null;
        }
        return externalSignedData.toDERBoolean().isTrue();
    }

    public CertInfoReq getMandatedCertificateInfo() {
        ASN1ValueHolder value = this.getValueHolder().getNextTaggedGetChild(2, 1, true);
        if (value == null) {
            return (CertInfoReq)CertInfoReq.FACTORY.createNew();
        }
        return (CertInfoReq)CertInfoReq.FACTORY.create(value);
    }

    public CertRefReq getMandatedCertificateRef() {
        ASN1ValueHolder value = this.getValueHolder().getNextTaggedGetChild(2, 0, true);
        if (value == null) {
            return (CertRefReq)CertRefReq.FACTORY.createNew();
        }
        return (CertRefReq)CertRefReq.FACTORY.create(value);
    }

    public List<String> getMandatedSignedAttr() {
        int index = 0;
        if (this.isExternalSignedDataPresent()) {
            ++index;
        }
        ASN1ValueHolder value = this.getValueHolder().getChild(index);
        return SignerRules.toOidList(value);
    }

    public List<String> getMandatedUnsignedAttr() {
        int index = 1;
        if (this.isExternalSignedDataPresent()) {
            ++index;
        }
        ASN1ValueHolder value = this.getValueHolder().getChild(index);
        return SignerRules.toOidList(value);
    }

    public SignPolExtensions getSignPolExtensions() {
        ASN1ValueHolder value = this.getValueHolder().getNextTaggedGetChild(2, 2, true);
        if (value == null) {
            return null;
        }
        return (SignPolExtensions)SignPolExtensions.FACTORY.create(value);
    }

    protected boolean isExternalSignedDataPresent() {
        if (this.getValueHolder().size() < 1) {
            return false;
        }
        return this.getValueHolder().getChild(0).getValue() instanceof ASN1Boolean;
    }

    public static class Factory
    extends ASN1Based.Factory<SignerRules> {
    }
}

