/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.policy;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.policy.NameConstraints;
import de.intarsys.asn1.policy.PolicyConstraints;
import de.intarsys.asn1.x509.Certificate;
import java.util.ArrayList;
import java.util.List;

public class CertificateTrustPoint
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public Certificate getTrustpoint() {
        return (Certificate)Certificate.FACTORY.create(this.getValueHolder().getChild(0));
    }

    public Integer getPathLenConstraint() {
        ASN1ValueHolder vh = this.getValueHolder().getNextTaggedGetChild(1, 0, true);
        if (vh == null) {
            return null;
        }
        return vh.toDERInteger().getPositiveValue().intValue();
    }

    public List<String> getAcceptablePolicySet() {
        ASN1ValueHolder vh = this.getValueHolder().getNextTaggedGetChild(1, 1, true);
        if (vh == null) {
            return null;
        }
        ArrayList<String> set = new ArrayList<String>();
        for (int i = 0; i < vh.size(); ++i) {
            set.add(vh.getChild(i).toDERObjectIdentifier().getId());
        }
        return set;
    }

    public NameConstraints getNameConstraints() {
        ASN1ValueHolder vh = this.getValueHolder().getNextTaggedGetChild(1, 2, true);
        if (vh == null) {
            return null;
        }
        return (NameConstraints)NameConstraints.FACTORY.create(vh);
    }

    public PolicyConstraints getPolicyConstraints() {
        ASN1ValueHolder vh = this.getValueHolder().getNextTaggedGetChild(1, 3, true);
        if (vh == null) {
            return null;
        }
        return (PolicyConstraints)PolicyConstraints.FACTORY.create(vh);
    }

    public static class Factory
    extends ASN1Based.Factory<CertificateTrustPoint> {
    }
}

