/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.common;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.model.ASN1ValueHolder;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;

public class AlgorithmIdentifier
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public static AlgorithmIdentifier create(String algorithmId) {
        AlgorithmIdentifier result = (AlgorithmIdentifier)FACTORY.createNew();
        result.setAlgorithm(algorithmId);
        result.setParameters((ASN1Encodable)DERNull.INSTANCE);
        return result;
    }

    public String getAlgorithm() {
        ASN1ObjectIdentifier identifier = this.getValueHolder().getChild(0).toDERObjectIdentifier();
        return identifier.getId();
    }

    public ASN1ValueHolder getParameters() {
        if (this.getValueHolder().size() > 1) {
            return this.getValueHolder().getChild(1);
        }
        return null;
    }

    public byte[] getParametersEncoded() throws IOException {
        if (this.getParameters() != null) {
            return ASN1Tools.toByteArray(this.getParameters());
        }
        return null;
    }

    protected void setAlgorithm(ASN1ObjectIdentifier algorithmIdentifier) {
        this.getValueHolder().setChild(0, (ASN1Encodable)algorithmIdentifier);
    }

    public void setAlgorithm(String algorithmIdentifier) {
        this.setAlgorithm(new ASN1ObjectIdentifier(algorithmIdentifier));
    }

    public void setParameters(ASN1Encodable parameterObject) {
        this.getValueHolder().setChild(1, parameterObject);
    }

    public static class Factory
    extends ASN1Based.Factory<AlgorithmIdentifier> {
    }
}

